ORCA/M Asm65816 2.1.0

0001 A805                       title 'DefProcs' 
0002 A805              **********************************************************************
0003 A805              *
0004 A805              * Control Manager Def Procs
0005 A805              *
0006 A805              * Copyright (C)
0007 A805              * Apple Computer, Inc. 1986-1992
0008 A805              * All Rights Reserved
0009 A805              *
0010 A805              * 28 Sep 88         Steven Glass
0011 A805              *
0012 A805              * Change in the way that the recsize routines can use the param
0013 A805              * field.  If the routines are called by NewControl, param is zero.
0014 A805              * If the routines are called by NewControl2, param is pointer to
0015 A805              * template.
0016 A805              *
0017 A805              * Added code to nor_size to see what kind of control is being built.
0018 A805              * When the control is super, it sees if the title or color table must
0019 A805              * be included in the control record when determining the size.
0020 A805              *
0021 A805              * Added code to simp_init to init the fields that are not inited
0022 A805              * by NewControl2
0023 A805              *
0024 A805              * Added simp_disp to release any resources accessed by the def_proc.
0025 A805              *
0026 A805              * 18 Nov 88         Steven Glass
0027 A805              *
0028 A805              * Check Invis bit in each draw routine:
0029 A805              *
0030 A805              *                   simp_draw
0031 A805              *                   check_draw
0032 A805              *                   radio_draw
0033 A805              *                   grow_draw
0034 A805              *                   scroll_draw
0035 A805              *
0036 A805              * Only draw if bit is clear.
0037 A805              *
0038 A805              * 07 Dec 88         Steven Glass
0039 A805              *
0040 A805              * PCount test in InitScroll was wrong.
0041 A805              *
0042 A805              * 19 Dec 88         Steven Glass
0043 A805              *
0044 A805              * In order to get the setup of the ColorPtr removed from the
0045 A805              * standard start drawing routines, I've put it into this
0046 A805              * file.  Every entry point that leads to drawing now must
0047 A805              * have a call to setupColor in it.  
0048 A805              *
0049 A805              * Moreover, all references to the color table after
0050 A805              * setup color must be made before any call that can move
0051 A805              * memory.
0052 A805              *
0053 A805              * Sure hope this works.
0054 A805              *
0055 A805              * 22 Feb 89         Harry Yee
0056 A805              *
0057 A805              * Dimming done on a simple button is different from dimming for any
0058 A805              * of the other standard controls. We were not checking the right flags
0059 A805              * to determine whether the control was a simple button or not therefore
0060 A805              * we were always dimming a control that was rectangular. Once we've
0061 A805              * determined that a control is a simple button we must also check whether
0062 A805              * its a rectangular or round button. If rectangular than dimming is done
0063 A805              * the same as that for other controls. BRC #44356.
0064 A805              *
0065 A805              * Modified MoveThumb routine. The colorptr was not being set up at the 
0066 A805              * right place. SetUpColor which sets up <colorptr was being called at
0067 A805              * a place that could get branched around. This caused problems because
0068 A805              * draw_thumb, which always gets called expects <colorptr to be set up. 
0069 A805              *
0070 A805              * 28 Mar 89         Steven Glass
0071 A805              *
0072 A805              * All defProcs now support the new ctlWinstateChange message.  All in
0073 A805              * this file just inval their ctlRects.
0074 A805              *
0075 A805              *
0076 A805              * 05 Apr 89         Dave Good
0077 A805              *
0078 A805              * The scroll bar and grow box defprocs now call the correct routine
0079 A805              * to invalidate their rects (they used to just jump to an rts).
0080 A805              *
0081 A805              * 06 Apr 89         Harry Yee
0082 A805              *
0083 A805              * Fix bug in grow box control init routine (init_grow). We use to just check
0084 A805              * the middle byte of the ctlColor field to see if the default color table
0085 A805              * should be used. If the ctlColor field was a resource ID then there was a
0086 A805              * good chance that the middle byte would be zero (i.e. ID = 1) and the ptr
0087 A805              * to the default color table would overwrite the resource ID. We now check
0088 A805              * to make the sure the high and low byte of ctlColor is zero before using
0089 A805              * the default.
0090 A805              *
0091 A805              * For buttons, radio buttons, and check boxes that use resources for their
0092 A805              * color table we were not releasing the color resource correctly. Fixed.
0093 A805              *
0094 A805              * 07 Apr 89         Harry Yee
0095 A805              *
0096 A805              * The Check box and radio button icon would not draw correctly if the control
0097 A805              * used a resource for its color table. In routine radio_check the x-reg comes
0098 A805              * set to value that tells the routine with icon to draw. Routine SetupColor
0099 A805              * was trashing the x-reg before it got used if the color table happened to be
0100 A805              * a resource. We now save the value of <x> on the stack before calling SetupColor.
0101 A805              * WorkSheet #BCOJHS099. 
0102 A805              *
0103 A805              * 28 Apr 89         Harry Yee
0104 A805              *
0105 A805              * Changed routine Radio_Check. The width of the radio button icon was not being
0106 A805              * set up correctly because routine get_csize requires the x-reg to be setup when 
0107 A805              * its called, which it wasn't. Going into routine get_csize x-reg was always zero. 
0108 A805              * Therefore when we drew the title we were calculating the x start position using 
0109 A805              * the width for a check box icon (which is icon number 0) instead of a radio 
0110 A805              * button icon.
0111 A805              *
0112 A805              **********************************************************************
0113 A805
0114 A805                       string asis 
0115 A805                       blanks off 
0116 A805
0117 A805                       print push 
0118 A805                       print off 
0119 A805
0120 A805                       include 'all.macros' 
0121 A805                       include 'equates.asm' 
0122 A805                       include 'superequates.asm' 
0123 A805                       include 'e16.event' 
0124 A805
0125 A805                       print pop 
0126 A805
0127 A805                       title 'SIMP_PROC' 
0128 A805              ;====================================================================
0129 A805              ;
0130 A805              ;          Main line Simple Button handler.
0131 A805              ;
0132 A805              ;   IN:    a = task.
0133 A805              ;          Ctlptr = pointer to control.
0134 A805              ;          param = additional parameter.
0135 A805              ;
0136 A805              ;  OUT:    a = low word of returned value.
0137 A805              ;          x = high word of returned value.
0138 A805              ;
0139 A805              ;====================================================================
0140 A805              simp_proc  proc EXPORT 
0141 A805
0142 A805 C9 14 00              cmp   #ctlWinStateChange+1     Ignore any messages out of range
0143 A808 B0 33                 bcs   null_ret
0144 A80A
0145 A80A 0A                    asl   a                        Compute index for dispatch.
0146 A80B AA                    tax   
0147 A80C BF 15 A8 FD           lda   >simp_tasks,x
0148 A810 48                    pha   
0149 A811 A2 FF FF              ldx   #$FFFF                   Simple buttom number.
0150 A814 60                    rts                            Complete the task.
0151 A815              ;
0152 A815 34 AA        simp_tasks DC W:simp_draw-1             0 Draw simple button.
0153 A817 3C A8                 DC W:null_ret-1                1 Compute drag RECT.
0154 A819 30 AA                 DC W:test_butt-1               2 Common hit test routine.
0155 A81B 12 A9                 DC W:simp_init-1               3 Initialize the control.
0156 A81D BF A8                 DC W:simp_disp-1               4 Dispose.
0157 A81F 34 AA                 DC W:simp_draw-1               5 New value.
0158 A821 3C A8                 DC W:null_ret-1                6 Compute Thumber constrains.
0159 A823 3C A8                 DC W:null_ret-1                7 Drag the indicator.
0160 A825 3C A8                 DC W:null_ret-1                8 Auto action.
0161 A827 34 AA                 DC W:simp_draw-1               9 New value.
0162 A829 3C A8                 DC W:null_ret-1                10 Set min max.
0163 A82B 3C A8                 DC W:null_ret-1                11 Move button.
0164 A82D FE A8                 DC W:nor_size-1                12 Return size of standard record.
0165 A82F 41 A8                 DC W:nor_event-1               13 Handle events
0166 A831 3C A8                 DC W:null_ret-1                14 ctlChangeTarget
0167 A833 3C A8                 DC W:null_ret-1                15 ctlChagneBounds
0168 A835 3C A8                 DC W:null_ret-1                16 ctlWindChagneSize
0169 A837 3C A8                 DC W:null_ret-1                17 ctlHandleTab
0170 A839 3C A8                 DC W:null_ret-1                18 ctlNotifyMultiPart
0171 A83B 65 AB                 DC W:Inval_rect-1              19 ctlWinStateChange (just inval)
0172 A83D                       ENDP 
0173 A83D
0174 A83D              ;====================================================================
0175 A83D              ;
0176 A83D              ;          Return Null
0177 A83D              ;
0178 A83D              ;====================================================================
0179 A83D              null_ret proc EXPORT 
0180 A83D              ;
0181 A83D A9 00 00              lda   #0                       Nothing flag.
0182 A840 AA                    tax   
0183 A841
0184 A841 60                    rts   
0185 A842
0186 A842                       ENDP 
0187 A842
0188 A842
0189 A842              ;====================================================================
0190 A842              ;
0191 A842              ;          nor_event
0192 A842              ;
0193 A842              ;====================================================================
0194 A842              nor_event proc EXPORT 
0195 A842
0196 A842 A0 11 00              ldy   #NewCtlRecord.ctlHilite
0197 A845 B7 05                 lda   [ctlPtr],y
0198 A847 29 FF 00              and   #$00FF
0199 A84A C9 FF 00              cmp   #$00FF
0200 A84D F0 66                 beq   DontWantIt
0201 A84F
0202 A84F A0 00 00              ldy   #oWhat
0203 A852 B7 29                 lda   [param],y
0204 A854 C9 03 00              cmp   #keyDownEvt
0205 A857 F0 05                 beq   TryThisOne
0206 A859
0207 A859 C9 05 00              cmp   #autoKeyEvt
0208 A85C D0 57                 bne   DontWantIt
0209 A85E
0210 A85E              TryThisOne  
0211 A85E
0212 A85E              ;
0213 A85E              ; Start with the modifiers.
0214 A85E              ;
0215 A85E A0 0E 00              ldy   #oModifiers              ; Look at the high byte
0216 A861 B7 29                 lda   [param],y                ; of the modifiers
0217 A863 29 00 FF              and   #$FF00
0218 A866 A0 2C 00              ldy   #NewCtlRecord.ctlKeyModsCareBits ; and with the care bits
0219 A869 37 05                 and   [ctlPtr],y
0220 A86B 88                    dey                            ; compare with the desired mods
0221 A86C 88                    dey   
0222 A86D D7 05                 cmp   [ctlPtr],y
0223 A86F D0 44                 bne   DontWantIt
0224 A871
0225 A871              ;
0226 A871              ; If we get to here, then the mods matched.  So look at the key.
0227 A871              ;
0228 A871 88                    dey   
0229 A872 88                    dey   
0230 A873 B7 05                 lda   [ctlPtr],y
0231 A875 AA                    tax   
0232 A876 29 FF 00              and   #$00FF                   ; first look at key1
0233 A879 A0 02 00              ldy   #oMessage
0234 A87C D7 29                 cmp   [param],y
0235 A87E F0 09                 beq   WantIt
0236 A880
0237 A880 8A                    txa                            ; now try key2
0238 A881 EB                    xba   
0239 A882 29 FF 00              and   #$00FF
0240 A885 D7 29                 cmp   [param],y
0241 A887 D0 2C                 bne   DontWantIt
0242 A889
0243 A889              WantIt    
0244 A889 A0 17 00              ldy   #NewCtlRecord.ctlProc+3
0245 A88C B7 05                 lda   [ctlPtr],y
0246 A88E 29 7F 00              and   #$007F
0247 A891 AA                    tax   
0248 A892 BF BA A8 FD           lda   >WhichPart,x
0249 A896 48                    pha   
0250 A897 D4 03                 pei   ctlHand+2
0251 A899 D4 01                 pei   ctlHand
0252 A89B A2 10 11 22           _HiliteControl 
0253 A8A2
0254 A8A2 F4 00 00              PushWord #0 
0255 A8A5 D4 03                 pei   ctlHand+2
0256 A8A7 D4 01                 pei   ctlHand
0257 A8A9 A2 10 11 22           _HiliteControl 
0258 A8B0
0259 A8B0 A9 FF FF              lda   #$FFFF                   Return true for having handled event
0260 A8B3 AA                    tax   
0261 A8B4 60                    rts   
0262 A8B5
0263 A8B5
0264 A8B5              DontWantIt  
0265 A8B5 A9 00 00              lda   #0                       Return False, don't want event.
0266 A8B8 AA                    tax   
0267 A8B9
0268 A8B9 60                    rts   
0269 A8BA
0270 A8BA
0271 A8BA
0272 A8BA
0273 A8BA              WhichPart  
0274 A8BA 02 00                 DC W:2                         ; button offset is 0, part is 2
0275 A8BC 03 00                 DC W:3                         ; check offset is 2, part is 3
0276 A8BE 04 00                 DC W:4                         ; radio offset is 4, part is 4
0277 A8C0                       ENDP 
0278 A8C0
0279 A8C0
0280 A8C0              ;====================================================================
0281 A8C0              ;
0282 A8C0              ;          simp_disp
0283 A8C0              ;
0284 A8C0              ; releases any resources used by the control
0285 A8C0              ;
0286 A8C0              ;====================================================================
0287 A8C0              simp_disp proc EXPORT 
0288 A8C0
0289 A8C0 A0 16 00              ldy   #NewCtlRecord.ctlProc+2
0290 A8C3 B7 05                 lda   [ctlPtr],y
0291 A8C5 10 33                 bpl   NeverMind
0292 A8C7
0293 A8C7 20 32 A2              jsr   ReadMoreFlags
0294 A8CA 29 03 00              and   #TitleVerbMask
0295 A8CD C9 02 00              cmp   #TitleIsResource
0296 A8D0 D0 0B                 bne   TitleNotResource
0297 A8D2
0298 A8D2 F4 06 80              PushWord #rString 
0299 A8D5 20 52 A2              jsr   CtlDataToAX
0300 A8D8 DA                    phx   
0301 A8D9 48                    pha   
0302 A8DA 20 90 9E              jsr   ReleaseResource
0303 A8DD
0304 A8DD              TitleNotResource  
0305 A8DD 20 32 A2              jsr   ReadMoreFlags
0306 A8E0 29 0C 00              and   #ColorTableVerbMask
0307 A8E3 C9 08 00              cmp   #ColorTableIsResource
0308 A8E6 D0 12                 bne   CTNotResource
0309 A8E8
0310 A8E8 F4 0D 80              PushWord #rCtlColorTable 
0311 A8EB
0312 A8EB A0 26 00              ldy   #NewCtlRecord.ctlColor+2
0313 A8EE B7 05                 lda   [<Ctlptr],y
0314 A8F0 48                    pha   
0315 A8F1 A0 24 00              ldy   #NewCtlRecord.ctlColor
0316 A8F4 B7 05                 lda   [<Ctlptr],y
0317 A8F6 48                    pha   
0318 A8F7
0319 A8F7 20 90 9E              jsr   ReleaseResource
0320 A8FA
0321 A8FA              CTNotResource  
0322 A8FA
0323 A8FA
0324 A8FA              NeverMind  
0325 A8FA A9 00 00              lda   #0
0326 A8FD AA                    tax   
0327 A8FE 60                    rts   
0328 A8FF
0329 A8FF                       ENDP 
0330 A8FF              ;====================================================================
0331 A8FF              ;
0332 A8FF              ;          Return size of required record.
0333 A8FF              ;
0334 A8FF              ;====================================================================
0335 A8FF              nor_size proc EXPORT 
0336 A8FF
0337 A8FF A5 29                 lda   param
0338 A901 05 2B                 ora   param+2
0339 A903 D0 07                 bne   EeeGads
0340 A905
0341 A905 A9 28 00              lda   #CtlColor+4              Size of standard control record.
0342 A908 A2 00 00              ldx   #0                       High word of size.
0343 A90B
0344 A90B 60                    rts   
0345 A90C
0346 A90C
0347 A90C              EeeGads   
0348 A90C A9 40 00              lda   #SuperCtlSize
0349 A90F A2 00 00              ldx   #0
0350 A912
0351 A912 60                    rts   
0352 A913
0353 A913
0354 A913                       ENDP 
0355 A913
0356 A913
0357 A913
0358 A913
0359 A913              ;====================================================================
0360 A913              ;
0361 A913              ;          Initialize simple button.
0362 A913              ;
0363 A913              ;   IN:    x = $FFFF to initialize a simple buttom.
0364 A913              ;          x = zero to initialize check box.
0365 A913              ;          x = 4 to initialize radio button.
0366 A913              ;          Ctlptr = control pointer.
0367 A913              ;
0368 A913              ; NewControl set all the fields but some defaults need 
0369 A913              ; expansion.
0370 A913              ;
0371 A913              ; NewControl2 requires that the same fields be expanded
0372 A913              ; and the indicated fields be set.  (They are initted to
0373 A913              ; zero.
0374 A913              ;
0375 A913              ;   ctlNext
0376 A913              ;   ctlOwner
0377 A913              ;   ctlRect *****
0378 A913              ;   ctlFlag
0379 A913              ;   ctlHilite
0380 A913              ;   ----- ctlValue
0381 A913              ;   ctlProc
0382 A913              ;   ----- ctlAction
0383 A913              ;   ----- ctldata
0384 A913              ;   ctlRefCon
0385 A913              ;   ----- ctlColor *****
0386 A913              ;   ctlID
0387 A913              ;   ctlType
0388 A913              ;   ctlSize
0389 A913              ;   ctlMoreFlags
0390 A913              ;   defProcVerb
0391 A913              ;
0392 A913              ; ----- means needs setting
0393 A913              ; ***** means needs expanding
0394 A913              ;
0395 A913              ;====================================================================
0396 A913              simp_init proc EXPORT 
0397 A913
0398 A913              ;-----------------------------------------------------------
0399 A913              ;
0400 A913              ; See who called us and init the fields accordingly.
0401 A913              ; (Use the high bit of the proc pointer to tell us.
0402 A913              ;
0403 A913
0404 A913 A0 16 00              ldy   #NewCtlRecord.CtlProc+2
0405 A916 B7 05                 lda   [ctlPtr],y
0406 A918 30 03                 bmi   CalledByNewCtl2
0407 A91A 82 7A 00              brl   CalledByNewCtl
0408 A91D
0409 A91D              CalledByNewCtl2  
0410 A91D DA                    phx                            ; save x
0411 A91E
0412 A91E
0413 A91E              ;-----------------------------------------------------------
0414 A91E              ;
0415 A91E              ; Copy the TitleRef from the template to the control record
0416 A91E              ; 3 out of 4 times, this is all there is to do.
0417 A91E              ;
0418 A91E A0 1A 00              ldy   #simpleButtonTemplate.TitleRef
0419 A921 B7 29                 lda   [param],y
0420 A923 AA                    tax   
0421 A924 C8                    iny   
0422 A925 C8                    iny   
0423 A926 B7 29                 lda   [param],y
0424 A928 A0 1E 00              ldy   #NewCtlRecord.ctlData+2
0425 A92B 97 05                 sta   [ctlPtr],y
0426 A92D 88                    dey   
0427 A92E 88                    dey   
0428 A92F 8A                    txa   
0429 A930 97 05                 sta   [ctlPtr],y
0430 A932
0431 A932              ;-----------------------------------------------------------
0432 A932              ;
0433 A932              ; The title is now correct.  Lets move on to the optional
0434 A932              ; parameters.  First, we look at the pCount to see if 
0435 A932              ; there are any optionals.
0436 A932              ;
0437 A932              ; The number is different for simplebuttons and others.
0438 A932              ;
0439 A932
0440 A932 A0 11 00              ldy   #simpleButtonTemplate.ProcRef+3
0441 A935 B7 29                 lda   [param],y
0442 A937 29 7F 00              and   #$007F
0443 A93A D0 2D                 bne   @NotSimple
0444 A93C
0445 A93C              ;-----------------------------------------------------------
0446 A93C              ;
0447 A93C              ; Its a simple button.  If the pcount is < 8, there are
0448 A93C              ; no optional parameters.  If it is 8 there is only a 
0449 A93C              ; color table.  If it is 9, there is a color table and
0450 A93C              ; key equivalents.
0451 A93C              ;
0452 A93C              @Simple   
0453 A93C A7 29                 lda   [param]
0454 A93E C9 08 00              cmp   #8
0455 A941 90 3F                 bcc   NoCT
0456 A943
0457 A943 C9 09 00              cmp   #9
0458 A946 90 2D                 bcc   YesCT                    ; no key equiv
0459 A948
0460 A948 A0 24 00              ldy   #SimpleButtonTemplate.KeyMods
0461 A94B
0462 A94B              ;
0463 A94B              ; Store away the key equiv data.  Start with the ctlKeyMods
0464 A94B              ;
0465 A94B B7 29        @JoinKeyEquiv lda   [param],y           ; read the mods
0466 A94D BB                    tyx                            ; save y into x
0467 A94E A0 2A 00              ldy   #NewCtlRecord.ctlKeyMods ; store away the mods
0468 A951 97 05                 sta   [ctlPtr],y
0469 A953 9B                    txy                            ; get y back from x
0470 A954 C8                    iny                            ; bump twice for care bits
0471 A955 C8                    iny   
0472 A956 B7 29                 lda   [param],y                ; read care bits
0473 A958 A0 2C 00              ldy   #NewCtlRecord.ctlKeyModsCareBits ; write into control record
0474 A95B 97 05                 sta   [ctlPtr],y
0475 A95D 9B                    txy                            ; get y back from x again
0476 A95E 88                    dey                            ; dec twice
0477 A95F 88                    dey   
0478 A960 B7 29                 lda   [param],y                ; read in key1 and key2
0479 A962 A0 28 00              ldy   #NewCtlRecord.ctlKey1    ; put into control record.
0480 A965 97 05                 sta   [ctlPtr],y
0481 A967 80 0C                 bra   YesCT
0482 A969
0483 A969
0484 A969              ;-----------------------------------------------------------
0485 A969              ;
0486 A969              ; Its a radio or check box.  If the pcount is < 9, there are
0487 A969              ; no optional parameters.  If it is 9 there is only a 
0488 A969              ; color table.  If it is 10, there is a color table and
0489 A969              ; key equivalents.
0490 A969              ;
0491 A969              @NotSimple  
0492 A969 A7 29                 lda   [param]
0493 A96B C9 09 00              cmp   #9
0494 A96E 90 12                 bcc   NoCT
0495 A970
0496 A970 A0 26 00              ldy   #RadioTemplate.KeyMods
0497 A973 80 D6                 bra   @JoinKeyEquiv
0498 A975
0499 A975              ;
0500 A975              ;
0501 A975              ;-----------------------------------------------------------
0502 A975              ;
0503 A975              ; There is a colortable ref.  The first thing we do is copy
0504 A975              ; it to the control record (just in case it is right). If 
0505 A975              ; we are using an offset, then we'll have to modify it below.
0506 A975              ;
0507 A975              YesCT     
0508 A975 20 38 A2              jsr   GetColorTableRefFromTemplate
0509 A978 A0 24 00              ldy   #NewCtlRecord.ctlColor
0510 A97B 97 05                 sta   [ctlPtr],y
0511 A97D C8                    iny   
0512 A97E C8                    iny   
0513 A97F 8A                    txa   
0514 A980 97 05                 sta   [ctlPtr],y
0515 A982
0516 A982
0517 A982
0518 A982              NoCT      
0519 A982
0520 A982
0521 A982              ;-----------------------------------------------------------
0522 A982              ;
0523 A982              ; Now we have to set the value for radio and check controls
0524 A982              ;
0525 A982
0526 A982 A0 17 00              ldy   #NewCtlRecord.ctlProc+3
0527 A985 B7 05                 lda   [ctlPtr],y
0528 A987 29 7F 00              and   #$007F
0529 A98A F0 0A                 beq   NoValue
0530 A98C
0531 A98C A0 1E 00              ldy   #checkTemplate.value
0532 A98F B7 29                 lda   [param],y
0533 A991 A0 12 00              ldy   #NewCtlRecord.ctlValue
0534 A994 97 05                 sta   [ctlPtr],y
0535 A996
0536 A996              NoValue   
0537 A996 FA                    plx                            ; restore x-reg
0538 A997
0539 A997
0540 A997              CalledByNewCtl  
0541 A997              ;
0542 A997              ; --- Set default sizes if needed --------------------------------
0543 A997              ;
0544 A997 A0 0C 00              ldy   #CtlRect+y2              Has the RECT already been set?
0545 A99A B7 05                 lda   [<Ctlptr],y
0546 A99C D0 73                 bne   init_clr
0547 A99E              ;
0548 A99E DA                    phx                            Save control type.
0549 A99F              ;
0550 A99F 20 30 A1              jsr   pushfontInfo             Get text font information.
0551 A9A2 A2 04 96 22           _GetFontInfo 
0552 A9A9              ;
0553 A9A9 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
0554 A9AC 48                    pha                            Space for width result.
0555 A9AD 20 EF A1              jsr   PushStringPtr
0556 A9B0 A2 04 A9 22           _StringWidth 
0557 A9B7              ;
0558 A9B7 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
0559 A9BA 68                    pla   
0560 A9BB A0 0A 00              ldy   #CtlRect+x1              Add width of title to starting position.
0561 A9BE 18                    clc   
0562 A9BF 77 05                 adc   [<Ctlptr],y
0563 A9C1              ;
0564 A9C1              ;
0565 A9C1 FA                    plx                            Restore control type,
0566 A9C2 DA                    phx                            and put back.
0567 A9C3 30 29                 bmi   do_simple                Is this a simple button.
0568 A9C5              ;
0569 A9C5              ;
0570 A9C5              ; --- Finish initializing check boxes and radio buttons ---------------
0571 A9C5              ;
0572 A9C5 48                    pha                            Save width so far.
0573 A9C6              ;
0574 A9C6 20 93 A3              jsr   get_csize                Get width and height of icon.
0575 A9C9              ;
0576 A9C9 A0 84 00              ldy   #fontInfo+ascent
0577 A9CC B7 41                 lda   [<data],y                Use max height of icon or text.
0578 A9CE 18                    clc   
0579 A9CF C8                    iny   
0580 A9D0 C8                    iny   
0581 A9D1 77 41                 adc   [<data],y
0582 A9D3 A0 21 00              ldy   #rect2+y2
0583 A9D6 D7 41                 cmp   [<data],y
0584 A9D8 90 02                 bcc   ok1
0585 A9DA 97 41                 sta   [<data],y                Use height of text instead of icon.
0586 A9DC              ;
0587 A9DC 68           ok1      pla                            Restore width so far,
0588 A9DD 18                    clc   
0589 A9DE A0 23 00              ldy   #rect2+x2
0590 A9E1 77 41                 adc   [<data],y                plus width of icon,
0591 A9E3 69 04 00              adc   #TITLE_SPACE             plus space between icon and title,
0592 A9E6 AA                    tax                            and put total width in x.
0593 A9E7 A0 21 00              ldy   #rect2+y2                Get height of icon,
0594 A9EA B7 41                 lda   [<data],y
0595 A9EC 80 12                 bra   store1                   and compute bottom side, set right side.
0596 A9EE              ;
0597 A9EE              ;
0598 A9EE              ; --- Finish initaializing simple button ------------------------------
0599 A9EE              ;
0600 A9EE 69 1E 00     do_simple adc   #30                     Plus a little extra for simple buttons.
0601 A9F1 AA                    tax                            Save right side in x.
0602 A9F2              ;          
0603 A9F2              ;
0604 A9F2              ; ------ Now set the bottom side -------------------------------------
0605 A9F2              ;
0606 A9F2 A0 84 00              ldy   #fontInfo+ascent
0607 A9F5 B7 41                 lda   [<data],y                Get system font's height.
0608 A9F7 18                    clc   
0609 A9F8 C8                    iny   
0610 A9F9 C8                    iny   
0611 A9FA 77 41                 adc   [<data],y
0612 A9FC 18                    clc   
0613 A9FD 69 06 00              adc   #6                       Add some leading.
0614 AA00              ;
0615 AA00 A0 08 00     store1   ldy   #CtlRect+y1
0616 AA03 18                    clc   
0617 AA04 77 05                 adc   [<Ctlptr],y              Add the height to the top side.
0618 AA06              ;
0619 AA06 A0 0C 00              ldy   #CtlRect+y2
0620 AA09 97 05                 sta   [<Ctlptr],y              Store the bottom side.
0621 AA0B C8                    iny   
0622 AA0C C8                    iny   
0623 AA0D 8A                    txa   
0624 AA0E 97 05                 sta   [<Ctlptr],y              Store the right side.
0625 AA10              ;
0626 AA10 FA                    plx   
0627 AA11              ;
0628 AA11              ;
0629 AA11              ; --- Set default color table if needed --------------------------
0630 AA11              ;
0631 AA11              ;          x = $FFFF for simple button color table.
0632 AA11              ;              else check box color table.
0633 AA11              ;
0634 AA11 A0 26 00     init_clr ldy   #CtlColor+2              Color table pointer already there?
0635 AA14 B7 05                 lda   [<Ctlptr],y
0636 AA16 D0 18                 bne   exit
0637 AA18 88                    dey   
0638 AA19 88                    dey   
0639 AA1A B7 05                 lda   [<CtlPtr],y
0640 AA1C D0 12                 bne   exit
0641 AA1E              ;
0642 AA1E C8                    iny                            Get Y back to CtlColor+1
0643 AA1F A9 A4 FD              lda   #butt_color>>8
0644 AA22 97 05                 sta   [<Ctlptr],y
0645 AA24 88                    dey   
0646 AA25 A9 95 A4              lda   #butt_color              Simple button color table.
0647 AA28 E8                    inx                            Are we initializing a simple button?
0648 AA29 F0 03                 beq   store2
0649 AA2B A9 9F A4              lda   #check_color             Check box/Radio button color table.
0650 AA2E 97 05        store2   sta   [<Ctlptr],y
0651 AA30
0652 AA30 60           exit     rts   
0653 AA31
0654 AA31                       ENDP 
0655 AA31
0656 AA31
0657 AA31              ;====================================================================
0658 AA31              ;
0659 AA31              ;          Test if given point is
0660 AA31              ;          inside the enclosing RECT.
0661 AA31              ;
0662 AA31              ;   IN:    param = point to check, param = y, param+2 = x.
0663 AA31              ;
0664 AA31              ;  OUT:    a = part code of found part,
0665 AA31              ;              zero if point not in enclosing RECT.
0666 AA31              ;
0667 AA31              ;====================================================================
0668 AA31              test_butt proc EXPORT 
0669 AA31
0670 AA31 A9 02 00              lda   #BUTT_PART               Simple button part code.
0671 AA34
0672 AA34 60                    rts   
0673 AA35
0674 AA35                       ENDP 
0675 AA35
0676 AA35
0677 AA35              ;====================================================================
0678 AA35              ;
0679 AA35              ;          Draw a simple button.
0680 AA35              ;
0681 AA35              ;   IN:    <ctlptr = control pointer.
0682 AA35              ;          <rect = enclosing rectangle.
0683 AA35              ;          <param = part to draw.
0684 AA35              ;          <colorptr = pointer to color table to use.
0685 AA35              ;
0686 AA35              ;====================================================================
0687 AA35              simp_draw proc EXPORT 
0688 AA35
0689 AA35              FrameRect equ   4+256*83
0690 AA35              FillRect equ   4+256*87
0691 AA35              FrameRRect equ   4+256*93
0692 AA35              FillRRect equ   4+256*97
0693 AA35              ;
0694 AA35              ;
0695 AA35 20 E8 B5              jsr   SetupColor               ; colorPtr now valid
0696 AA38
0697 AA38 20 D8 B5              jsr   CheckForVis              If not visible, don't come back
0698 AA3B
0699 AA3B A0 10 00              ldy   #CtlFlag                 Read the flag
0700 AA3E B7 05                 lda   [<Ctlptr],y
0701 AA40 AA                    tax                            Save flag.
0702 AA41 29 01 00              and   #$0001                   Bold/Single and drop shadow bit.
0703 AA44 85 2D                 sta   <work
0704 AA46 8A                    txa   
0705 AA47              ;
0706 AA47 A2 04 53              ldx   #FrameRect               Square corner functions.
0707 AA4A A0 04 57              ldy   #FillRect
0708 AA4D              ;
0709 AA4D 29 02 00              and   #$0002                   Round or square corners.
0710 AA50 85 2F                 sta   <work+2                  0=round, 2=square.
0711 AA52 D0 06                 bne   store1
0712 AA54              ;
0713 AA54 A2 04 5D              ldx   #FrameRRect              Round corner functions.
0714 AA57 A0 04 61              ldy   #FillRRect
0715 AA5A              ;
0716 AA5A 86 31        store1   stx   <work+4                  Frame function.
0717 AA5C 84 33                 sty   <work+6                  Fill function.
0718 AA5E              ;
0719 AA5E              ;
0720 AA5E              ; --- Draw round button's interior background and frame ------------
0721 AA5E              ;
0722 AA5E 20 64 A1              jsr   pushVvert_pen
0723 AA61 68                    pla   
0724 AA62 1A                    inc   a                        A little more for vertical lines.
0725 AA63 48                    pha   
0726 AA64 F4 01 00              pea   1
0727 AA67 A2 04 2C 22           _SetPenSize 
0728 AA6E              ;
0729 AA6E 20 72 A1              jsr   pushrect                 Pass pointer to RECT.
0730 AA71              ;
0731 AA71 A5 2F                 lda   <work+2                  Round or square?
0732 AA73 D0 11                 bne   skip5
0733 AA75              ;
0734 AA75 A2 0D 00              ldx   #13
0735 AA78 A0 4A 00              ldy   #GraphicsMode
0736 AA7B B7 41                 lda   [<data],y                320 or 640?
0737 AA7D F0 03                 beq   store2
0738 AA7F A2 1A 00              ldx   #26
0739 AA82 DA           store2   phx                            Oval width.
0740 AA83 F4 08 00              pea   8                        Oval height for fill.
0741 AA86              ;
0742 AA86 A0 50 00     skip5    ldy   #state
0743 AA89 B7 41                 lda   [<data],y
0744 AA8B 1A                    inc   a
0745 AA8C 1A                    inc   a
0746 AA8D A8                    tay   
0747 AA8E 20 05 A1              jsr   pushcolor                Pass pointer to color pattern.
0748 AA91 A6 33                 ldx   <work+6                  Use Fill function.
0749 AA93 22 00 00 E1           jsl   $E10000
0750 AA97              ;
0751 AA97 A0 00 00              ldy   #simpOutline
0752 AA9A 20 05 A1              jsr   pushcolor                Pass pointer to color pattern.
0753 AA9D A2 04 30 22           _SetPenPat                     Set color of frame.
0754 AAA4              ;
0755 AAA4 20 72 A1              jsr   pushrect                 Pass pointer to RECT.
0756 AAA7              ;
0757 AAA7 A5 2F                 lda   <work+2                  Round or Square?
0758 AAA9 D0 11                 bne   skip7
0759 AAAB              ;
0760 AAAB A2 0D 00              ldx   #13
0761 AAAE A0 4A 00              ldy   #GraphicsMode
0762 AAB1 B7 41                 lda   [<data],y                320 or 640?
0763 AAB3 F0 03                 beq   store3
0764 AAB5 A2 1A 00              ldx   #26
0765 AAB8 DA           store3   phx                            Oval width.
0766 AAB9 F4 08 00              pea   8                        Oval height for fill.
0767 AABC              ;
0768 AABC A6 31        skip7    ldx   <work+4                  Frame function.
0769 AABE 22 00 00 E1           jsl   $E10000
0770 AAC2              ;
0771 AAC2              ;
0772 AAC2              ; --- Draw special outlines ---------------------------------------------
0773 AAC2              ;
0774 AAC2 A5 2D                 lda   <work                    Anything special?
0775 AAC4 F0 64                 beq   skip1
0776 AAC6              ;
0777 AAC6 A5 2F                 lda   <work+2                  Round or square?
0778 AAC8 F0 3F                 beq   roundBold
0779 AACA              ;
0780 AACA              ; ------ Drop shadow the square button ----------------------------------
0781 AACA              ;
0782 AACA A4 1B                 ldy   <rect+x2
0783 AACC 5A                    phy                            Pass last point.
0784 AACD A5 15                 lda   <rect+y1
0785 AACF 1A                    inc   a
0786 AAD0 1A                    inc   a
0787 AAD1 48                    pha   
0788 AAD2              ;
0789 AAD2 5A                    phy                            Set second point.
0790 AAD3 A6 19                 ldx   <rect+y2
0791 AAD5 DA                    phx   
0792 AAD6              ;
0793 AAD6 DA                    phx                            Save x.
0794 AAD7 20 64 A1              jsr   pushVvert_pen
0795 AADA 68                    pla                            Get vertical height of lines.
0796 AADB FA                    plx                            Restore x.
0797 AADC 0A                    asl   a                        Set starting point.
0798 AADD 18                    clc   
0799 AADE 65 17                 adc   <rect+x1
0800 AAE0 48                    pha   
0801 AAE1 DA                    phx   
0802 AAE2 A2 04 3A 22           _MoveTo 
0803 AAE9 A2 04 3C 22           _LineTo                        Bottom dropshadow.
0804 AAF0              ;
0805 AAF0 20 64 A1              jsr   pushVvert_pen
0806 AAF3 68                    pla   
0807 AAF4 0A                    asl   a                        Vertical width.
0808 AAF5 48                    pha                            Line width.
0809 AAF6 F4 01 00              pea   1                        Line height.
0810 AAF9 A2 04 2C 22           _SetPenSize 
0811 AB00 A2 04 3C 22           _LineTo 
0812 AB07              ;
0813 AB07 80 21                 bra   skip1
0814 AB09              ;
0815 AB09              ;
0816 AB09              ; ------ Draw a bold outline --------------------------------------------
0817 AB09              ;
0818 AB09 20 4F AB     roundBold jsr   expandButt
0819 AB0C              ;
0820 AB0C 20 72 A1              jsr   pushrect                 Pass pointer to RECT.
0821 AB0F A2 12 00              ldx   #18
0822 AB12 A0 4A 00              ldy   #GraphicsMode
0823 AB15 B7 41                 lda   [<data],y                320 or 640?
0824 AB17 F0 03                 beq   store4
0825 AB19 A2 24 00              ldx   #36
0826 AB1C DA           store4   phx                            Oval width.
0827 AB1D F4 0C 00              pea   12                       Oval height.
0828 AB20 A2 04 5D 22           _FrameRRect 
0829 AB27              ;
0830 AB27 20 2C A4              jsr   CMsetrect                Restore enclosing RECT into 'rect'.
0831 AB2A              ;
0832 AB2A A2 04 36 22  skip1    _PenNormal 
0833 AB31              ;
0834 AB31              ;
0835 AB31              ; --- Print string in button ----------------------
0836 AB31              ;
0837 AB31              ; ------ Find title's width -----------------------
0838 AB31              ;
0839 AB31 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
0840 AB34 48                    pha                            Space to width result.
0841 AB35 20 EF A1              jsr   PushStringPtr
0842 AB38 A2 04 A9 22           _StringWidth 
0843 AB3F              ;
0844 AB3F              ;
0845 AB3F              ; ------ Center title horizontally ----------------
0846 AB3F              ;
0847 AB3F A5 1B                 lda   <rect+x2
0848 AB41 38                    sec   
0849 AB42 E5 17                 sbc   <rect+x1                 Width of button.
0850 AB44 E3 01                 sbc   1,s                      Less width of string.
0851 AB46 4A                    lsr   a                        Half way.
0852 AB47 18                    clc   
0853 AB48 65 17                 adc   <rect+x1                 Starting position.
0854 AB4A AA                    tax                            Pass X starting position in x.
0855 AB4B 68                    pla                            Get rid of width.
0856 AB4C              ;
0857 AB4C 82 9A 00              brl   drawtitle                Print title in button.
0858 AB4F              ;
0859 AB4F              ;
0860 AB4F              ; = = = = = = = = = = = = = = = = = = = = = = = = =
0861 AB4F              ;          Expand button for bold outine.
0862 AB4F              ; = = = = = = = = = = = = = = = = = = = = = = = = =
0863 AB4F              ;
0864 AB4F              ;   IN:    rect = RECT to expand, and is equal to button's enclosing RECT.
0865 AB4F              ;
0866 AB4F              ;  OUT:    rect = size of bolded button.
0867 AB4F              ;
0868 AB4F                       EXPORT expandButt 
0869 AB4F              expandButt                              ;
0870 AB4F              ;
0871 AB4F 20 72 A1              jsr   pushrect                 Pass pointer of RECT to expand.
0872 AB52              ;
0873 AB52 20 64 A1              jsr   pushVvert_pen
0874 AB55 68                    pla   
0875 AB56 1A                    inc   a
0876 AB57 49 FF FF              eor   #$FFFF                   Make it expand.
0877 AB5A              ;          inc   a
0878 AB5A 48                    pha   
0879 AB5B F4 FE FF              pea   $FFFE
0880 AB5E A2 04 4C 22           _InsetRect 
0881 AB65
0882 AB65 60                    rts   
0883 AB66              ;
0884 AB66                       ENDP 
0885 AB66
0886 AB66
0887 AB66
0888 AB66
0889 AB66              ;====================================================================
0890 AB66              ;
0891 AB66              ;          Invals bounding rect of control
0892 AB66              ;
0893 AB66              ;   IN:    ctlPtr
0894 AB66              ;
0895 AB66              ;  OUT:    a and x = 0
0896 AB66              ;
0897 AB66              ;====================================================================
0898 AB66              Inval_rect proc 
0899 AB66
0900 AB66 A5 05                 lda   ctlPtr
0901 AB68 18                    clc   
0902 AB69 69 08 00              adc   #NewCtlRecord.ctlRect
0903 AB6C AA                    tax   
0904 AB6D A5 07                 lda   ctlPtr+2
0905 AB6F 69 00 00              adc   #0
0906 AB72 48                    pha   
0907 AB73 DA                    phx   
0908 AB74 A2 0E 3A 22           _InvalRect 
0909 AB7B
0910 AB7B
0911 AB7B AA                    tax   
0912 AB7C
0913 AB7C 60                    rts   
0914 AB7D
0915 AB7D                       ENDP 
0916 AB7D
0917 AB7D
0918 AB7D                       title 'CHECK_PROC' 
0919 AB7D              ;====================================================================
0920 AB7D              ;
0921 AB7D              ;          Main line Check Box handler.
0922 AB7D              ;
0923 AB7D              ;   IN:    a = task.
0924 AB7D              ;          Ctlptr = pointer to control.
0925 AB7D              ;          param = additional parameter.
0926 AB7D              ;
0927 AB7D              ;  OUT:    a = low word of returned value.
0928 AB7D              ;          x = high word of returned value.
0929 AB7D              ;
0930 AB7D              ;====================================================================
0931 AB7D              check_proc  proc EXPORT 
0932 AB7D C9 14 00              cmp   #ctlWinStateChange+1     make sure I can handle message
0933 AB80 90 03                 bcc   @ok
0934 AB82 82 B8 FC              brl   null_ret
0935 AB85              @ok       
0936 AB85
0937 AB85 0A                    asl   a                        Compute index for dispatch.
0938 AB86 AA                    tax   
0939 AB87 BF 90 AB FD           lda   >task_list,x
0940 AB8B 48                    pha   
0941 AB8C A2 00 00              ldx   #0                       Check box number.
0942 AB8F 60                    rts                            Complete the task.
0943 AB90              ;
0944 AB90 BB AB        task_list DC W:check_draw-1             Draw.
0945 AB92 3C A8                 DC W:null_ret-1                Compute drag RECT.
0946 AB94 B7 AB                 DC W:checkboxHit-1             Hit test routine.
0947 AB96 12 A9                 DC W:simp_init-1               Initialize the control.
0948 AB98 BF A8                 DC W:simp_disp-1               Dispose.
0949 AB9A BB AB                 DC W:check_draw-1              New value.
0950 AB9C 3C A8                 DC W:null_ret-1                Compute Thumber constrains.
0951 AB9E 3C A8                 DC W:null_ret-1                Drag the indicator.
0952 ABA0 3C A8                 DC W:null_ret-1                Auto action.
0953 ABA2 BB AB                 DC W:check_draw-1              New value.
0954 ABA4 3C A8                 DC W:null_ret-1                Set min max.
0955 ABA6 3C A8                 DC W:null_ret-1                Move control.
0956 ABA8 FE A8                 DC W:nor_size-1                Return size of standard record.
0957 ABAA 41 A8                 DC W:nor_event-1               13 Handle events
0958 ABAC 3C A8                 DC W:null_ret-1                14 ctlChangeTarget
0959 ABAE 3C A8                 DC W:null_ret-1                15 ctlChagneBounds
0960 ABB0 3C A8                 DC W:null_ret-1                16 ctlWindChagneSize
0961 ABB2 3C A8                 DC W:null_ret-1                17 ctlHandleTab
0962 ABB4 3C A8                 DC W:null_ret-1                18 ctlNotifyMultiPart
0963 ABB6 65 AB                 DC W:Inval_rect-1              19 ctlWinStateChange (just inval)
0964 ABB8
0965 ABB8                       ENDP 
0966 ABB8
0967 ABB8
0968 ABB8              ;====================================================================
0969 ABB8              ;
0970 ABB8              ;          Test if given point is
0971 ABB8              ;          inside the enclosing RECT.
0972 ABB8              ;
0973 ABB8              ;   IN:    param = point to check, param = y, param+2 = x.
0974 ABB8              ;
0975 ABB8              ;  OUT:    a = check box part code of found part.
0976 ABB8              ;
0977 ABB8              ;  To get this far, the point must be inside the control's enclosing RECT.
0978 ABB8              ;  So, just return the part code to signal a hit.
0979 ABB8              ;
0980 ABB8              ;====================================================================
0981 ABB8              checkboxHit proc EXPORT 
0982 ABB8
0983 ABB8 A9 03 00              lda   #CHECK_PART              Return part code in A.
0984 ABBB
0985 ABBB 60                    rts   
0986 ABBC
0987 ABBC                       ENDP 
0988 ABBC
0989 ABBC
0990 ABBC              ;====================================================================
0991 ABBC              ;
0992 ABBC              ;          Draw a check box.
0993 ABBC              ;
0994 ABBC              ;   IN:    rect = control's enclosing rectangle.
0995 ABBC              ;          state = 0 if unhilited, 2 if hilited.
0996 ABBC              ;          active = 0 if active, $FFFF if inactive.
0997 ABBC              ;
0998 ABBC              ;
0999 ABBC              ;====================================================================
1000 ABBC              check_draw proc EXPORT 
1001 ABBC
1002 ABBC A2 00 00              ldx   #0                       Check box icon number.
1003 ABBF
1004 ABBF              ;
1005 ABBF              ; = = = = = = = = = = = = = = = = = = = = = = = =
1006 ABBF              ;          Draw radio button or check box.
1007 ABBF              ; = = = = = = = = = = = = = = = = = = = = = = = =
1008 ABBF              ;
1009 ABBF              ;   IN:    x = 0 for check box, 4 for radio button.
1010 ABBF              ;          <rect = control's enclosing rectangle.
1011 ABBF              ;          <colorptr = pointer to color table to use.
1012 ABBF              ;          state = 0 if unhilited, 2 if hilited.
1013 ABBF              ;          active = 0 if active, $FFFF if inactive.
1014 ABBF              ;
1015 ABBF                       EXPORT radio_check 
1016 ABBF              radio_check                             ;
1017 ABBF
1018 ABBF 20 D8 B5              jsr   CheckForVis              If not visible, don't come back--x preserved
1019 ABC2
1020 ABC2 DA                    phx                            Save the icon number since it might get trashed by 
1021 ABC3 20 E8 B5              jsr   SetupColor               SetupColor if we need to load a resource.
1022 ABC6
1023 ABC6              ;
1024 ABC6              ; --- Draw icon -----------------------------------------------
1025 ABC6              ;
1026 ABC6 FA                    plx                            Restore the icon number.
1027 ABC7 DA                    phx                            Get icon number in x, but save number on stack still
1028 ABC8 A0 12 00              ldy   #CtlValue                Is the box checked?
1029 ABCB B7 05                 lda   [<Ctlptr],y
1030 ABCD F0 02                 beq   skip1
1031 ABCF E8                    inx   
1032 ABD0 E8                    inx   
1033 ABD1 20 BB AC     skip1    jsr   print_icon               Draw the icon.
1034 ABD4
1035 ABD4 FA                    plx                            Restore icon number in x as input for get_csize
1036 ABD5 A5 29                 lda   <param                   Does the title need to be drawn?
1037 ABD7 F0 01                 beq   ok1                      Only if drawing whole control.
1038 ABD9
1039 ABD9 60                    rts   
1040 ABDA
1041 ABDA 20 93 A3     ok1      jsr   get_csize                Get the size of the icon.
1042 ABDD              ;
1043 ABDD A0 23 00              ldy   #rect2+x2                Width of the icon,
1044 ABE0 B7 41                 lda   [<data],y
1045 ABE2 18                    clc   
1046 ABE3 65 17                 adc   <rect+x1                 plus starting x position,
1047 ABE5 69 04 00              adc   #TITLE_SPACE             plus space,
1048 ABE8 AA                    tax                            equals title's starting x position.
1049 ABE9              ;
1050 ABE9              ;
1051 ABE9              ; = = = = = = = = = = = = = = = = = =
1052 ABE9              ;        Draw control's title.
1053 ABE9              ; = = = = = = = = = = = = = = = = = =
1054 ABE9              ;
1055 ABE9              ;   IN:  state = 0 for normal, 2 for hilited.
1056 ABE9              ;        x = starting x position of text.
1057 ABE9              ;        <rect = control's enclosing rectangle.
1058 ABE9              ;
1059 ABE9              ;  OUT:  Title centered vertically and printed.
1060 ABE9              ;
1061 ABE9                       EXPORT DrawTitle 
1062 ABE9              drawtitle                               ;
1063 ABE9 DA                    phx                            Save.
1064 ABEA 20 30 A1              jsr   pushfontInfo             Get text font information.
1065 ABED A2 04 96 22           _GetFontInfo 
1066 ABF4 FA                    plx                            Restore.
1067 ABF5              ;
1068 ABF5 A5 19                 lda   <rect+y2                 Center text vertically in 'rect'.
1069 ABF7 38                    sec   
1070 ABF8 E5 15                 sbc   <rect+y1                 Height of button.
1071 ABFA A0 84 00              ldy   #fontInfo+ascent
1072 ABFD F7 41                 sbc   [<data],y                Less height of string.
1073 ABFF 90 46                 bcc   ck_dimm                  Does the title fit?
1074 AC01 4A                    lsr   a                        Half way.
1075 AC02 18                    clc   
1076 AC03 65 15                 adc   <rect+y1                 Starting position.
1077 AC05 18                    clc   
1078 AC06 77 41                 adc   [<data],y
1079 AC08 A8                    tay                            Pass starting Y position.
1080 AC09 20 18 AD              jsr   set_penpos               Set pen position.
1081 AC0C              ;
1082 AC0C              ;
1083 AC0C 48                    pha                            Space for result.
1084 AC0D A2 04 99 22           _GetFontFlags 
1085 AC14 48                    pha                            Space for result.
1086 AC15 A2 04 9D 22           _GetTextMode 
1087 AC1C              ;
1088 AC1C              ;
1089 AC1C A9 06 00              lda   #SimpNorText
1090 AC1F 20 1C 9F              jsr   set_textmode
1091 AC22              ;
1092 AC22 F4 04 00              pea   4                        Use word of color.
1093 AC25 A2 04 98 22           _SetFontFlags 
1094 AC2C              ;
1095 AC2C 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
1096 AC2F 20 EF A1              jsr   PushStringPtr
1097 AC32 A2 04 A5 22           _DrawString                    Print string.
1098 AC39              ;
1099 AC39 A2 04 9C 22           _SetTextMode                   Restore original text mode.
1100 AC40 A2 04 98 22           _SetFontFlags                  Restore original text flags.
1101 AC47              ;
1102 AC47              ;
1103 AC47                       EXPORT ck_dimm 
1104 AC47              ck_dimm                                 ;
1105 AC47              ;
1106 AC47 A0 4E 00              ldy   #active                  Is the control active?
1107 AC4A B7 41                 lda   [<data],y
1108 AC4C 10 6C                 bpl   exit                     If yes, don't disable.
1109 AC4E              ;
1110 AC4E              ;
1111 AC4E              ; --- Disable the control -----------------------------------------
1112 AC4E              ;
1113 AC4E F4 FD 00              pea   dimmed>>16               Set pen to dim mask.
1114 AC51 F4 45 A4              pea   dimmed
1115 AC54 A2 04 32 22           _SetPenMask 
1116 AC5B              ;
1117 AC5B 20 72 A1              jsr   pushrect                 Pass pointer of item's RECT.
1118 AC5E              ;                                       Disabled can't be selected.
1119 AC5E              ;
1120 AC5E 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
1121 AC61 A0 16 00              ldy   #Ctlproc+2               Is the control a simple button?
1122 AC64 B7 05                 lda   [<Ctlptr],y
1123 AC66 29 FF 7F              and   #$7FFF                   Make sure we mask off the high bit just in case this is super
1124 AC69 D0 35                 bne   ItsSquare
1125 AC6B
1126 AC6B A0 10 00              ldy   #Ctlflag                 Its a simple button, but is it square or round
1127 AC6E B7 05                 lda   [<Ctlptr],y
1128 AC70 29 02 00              and   #$0002
1129 AC73 D0 2B                 bne   ItsSquare                Button is square
1130 AC75              ;
1131 AC75 F4 0C 00              pea   12                       oval width (defining rounded corner of button)
1132 AC78 F4 0C 00              pea   12                       oval height
1133 AC7B              ;
1134 AC7B E6 15                 inc   <rect+y1                 Inset the control's rect
1135 AC7D C6 19                 dec   <rect+y2                 Don't disable outline of simple button
1136 AC7F 20 64 A1              jsr   pushVvert_pen            (only reason to do this is because the MAC does this)
1137 AC82 A5 17                 lda   <rect+x1
1138 AC84 18                    clc   
1139 AC85 63 01                 adc   1,s
1140 AC87 85 17                 sta   <rect+x1
1141 AC89 A5 1B                 lda   <rect+x2
1142 AC8B 38                    sec   
1143 AC8C E3 01                 sbc   1,s
1144 AC8E 85 1B                 sta   <rect+x2
1145 AC90 68                    pla                            Get vertical pen width off stack
1146 AC91
1147 AC91 A0 06 00              ldy   #simpNorText
1148 AC94 20 05 A1              jsr   pushcolor                Push pointer to color pattern.
1149 AC97
1150 AC97 A2 04 61 22           _FillRRect                     FillRect function number
1151 AC9E
1152 AC9E 80 0D                 bra   skip4
1153 ACA0              ;
1154 ACA0              ;
1155 ACA0 A0 06 00     ItsSquare ldy   #simpNorText
1156 ACA3 20 05 A1              jsr   pushcolor                Push pointer to color pattern.
1157 ACA6
1158 ACA6 A2 04 57 22           _FillRect                      FillRect function number
1159 ACAD              ;
1160 ACAD F4 FD 00     skip4    pea   nor_mask>>16             Reset drawing mask to normal solid.
1161 ACB0 F4 4D A4              pea   nor_mask
1162 ACB3 A2 04 32 22           _SetPenMask 
1163 ACBA              ;
1164 ACBA 60           exit     rts   
1165 ACBB
1166 ACBB                       ENDP 
1167 ACBB
1168 ACBB
1169 ACBB              ;====================================================================
1170 ACBB              ;
1171 ACBB              ;          Print an icon.
1172 ACBB              ;
1173 ACBB              ;   IN:    x = icon number.
1174 ACBB              ;          state = hilite state.
1175 ACBB              ;          rect = where to print.
1176 ACBB              ;
1177 ACBB              ;====================================================================
1178 ACBB              print_icon proc EXPORT 
1179 ACBB
1180 ACBB A0 50 00              ldy   #state
1181 ACBE B7 41                 lda   [<data],y
1182 ACC0 F0 05                 beq   ok1
1183 ACC2
1184 ACC2 8A                    txa   
1185 ACC3 09 01 00              ora   #1                       Use hilited version of icon.
1186 ACC6 AA                    tax   
1187 ACC7              ;
1188 ACC7 8A           ok1      txa   
1189 ACC8              ;
1190 ACC8              ;
1191 ACC8                       EXPORT draw_icon 
1192 ACC8              draw_icon                               ;
1193 ACC8 85 2D                 sta   <work                    Store icon (character) number.
1194 ACCA 20 95 A3              jsr   get_csize2               Get icon's size.
1195 ACCD              ;           
1196 ACCD A5 19                 lda   <rect+y2                 Center icon vertically in 'rect'.
1197 ACCF 38                    sec   
1198 ACD0 E5 15                 sbc   <rect+y1                 Height of button.
1199 ACD2 A0 21 00              ldy   #rect2+y2
1200 ACD5 F7 41                 sbc   [<data],y                Less height of icon.
1201 ACD7 90 3E                 bcc   dontFit
1202 ACD9 4A                    lsr   a                        Half way.
1203 ACDA 18                    clc   
1204 ACDB 65 15                 adc   <rect+y1                 Starting position.
1205 ACDD A8                    tay                            Pass starting Y position.
1206 ACDE A6 17                 ldx   <rect+x1
1207 ACE0 20 18 AD              jsr   set_penpos               Set pen position.
1208 ACE3              ;
1209 ACE3 48                    pha                            Space for result.
1210 ACE4 A2 04 99 22           _GetFontFlags                  Save state.
1211 ACEB 48                    pha                            Space for result.
1212 ACEC A2 04 9D 22           _GetTextMode                   Save state.
1213 ACF3              ;
1214 ACF3 A9 02 00              lda   #simpNorBack             Icon color index.
1215 ACF6 20 1C 9F              jsr   set_textmode             Set icon color and OR mode.
1216 ACF9              ;
1217 ACF9 A9 0E AD              lda   #drawChar                Address of function to perform while
1218 ACFC 20 98 A3              jsr   doIconFunc               icon font is current.
1219 ACFF              ;
1220 ACFF A2 04 9C 22           _SetTextMode                   Restore original text mode.
1221 AD06 A2 04 98 22           _SetFontFlags                  Restore original text flags.
1222 AD0D
1223 AD0D 60                    rts   
1224 AD0E
1225 AD0E
1226 AD0E D4 2D        drawChar pei   <work                    Pass character (icon number) to print.
1227 AD10 A2 04 A4 22           _DrawChar 
1228 AD17
1229 AD17 60           dontFit  rts   
1230 AD18
1231 AD18                       ENDP 
1232 AD18
1233 AD18
1234 AD18              ;====================================================================
1235 AD18              ;
1236 AD18              ;        Move pen to a given point without drawing.
1237 AD18              ;
1238 AD18              ;   IN:    y = y coordinate.
1239 AD18              ;          x = x coordinate.
1240 AD18              ;
1241 AD18              ;====================================================================
1242 AD18              set_penpos proc EXPORT 
1243 AD18
1244 AD18 DA                    phx   
1245 AD19 5A                    phy   
1246 AD1A A2 04 3A 22           _MoveTo 
1247 AD21
1248 AD21 60                    rts   
1249 AD22
1250 AD22                       ENDP 
1251 AD22
1252 AD22                       title 'RADIO_PROC' 
1253 AD22              ;====================================================================
1254 AD22              ;
1255 AD22              ;          Main line Radio Button handler.
1256 AD22              ;
1257 AD22              ;   IN:    a = task.
1258 AD22              ;          Ctlptr = pointer to control.
1259 AD22              ;          param = additional parameter.
1260 AD22              ;
1261 AD22              ;  OUT:    a = low word of returned value.
1262 AD22              ;          x = high word of returned value.
1263 AD22              ;
1264 AD22              ;====================================================================
1265 AD22              radio_proc  proc EXPORT 
1266 AD22 C9 14 00              cmp   #ctlWinStateChange+1     make sure I can handle message
1267 AD25 90 03                 bcc   @ok
1268 AD27 82 13 FB              brl   null_ret
1269 AD2A              @ok       
1270 AD2A
1271 AD2A 0A                    asl   a                        Compute index for dispatch.
1272 AD2B AA                    tax   
1273 AD2C BF 35 AD FD           lda   >task_list,x
1274 AD30 48                    pha   
1275 AD31 A2 04 00              ldx   #4                       Radio button number.
1276 AD34 60                    rts                            Complete the task.
1277 AD35              ;
1278 AD35 60 AD        task_list DC W:radio_draw-1             Draw.
1279 AD37 3C A8                 DC W:null_ret-1                Compute drag RECT.
1280 AD39 5C AD                 DC W:radioHit-1                Common hit test routine.
1281 AD3B 12 A9                 DC W:simp_init-1               Initialize the control.
1282 AD3D BF A8                 DC W:simp_disp-1               Dispose.
1283 AD3F 60 AD                 DC W:radio_draw-1              Called after drag.
1284 AD41 3C A8                 DC W:null_ret-1                Compute Thumber constrains.
1285 AD43 3C A8                 DC W:null_ret-1                Drag the indicator.
1286 AD45 3C A8                 DC W:null_ret-1                Auto action.
1287 AD47 66 AD                 DC W:radio_set-1               New value.
1288 AD49 3C A8                 DC W:null_ret-1                Set min max.
1289 AD4B 3C A8                 DC W:null_ret-1                Move control.
1290 AD4D FE A8                 DC W:nor_size-1                Return size of standard record.
1291 AD4F 41 A8                 DC W:nor_event-1               13 Handle events
1292 AD51 3C A8                 DC W:null_ret-1                14 ctlChangeTarget
1293 AD53 3C A8                 DC W:null_ret-1                15 ctlChagneBounds
1294 AD55 3C A8                 DC W:null_ret-1                16 ctlWindChagneSize
1295 AD57 3C A8                 DC W:null_ret-1                17 ctlHandleTab
1296 AD59 3C A8                 DC W:null_ret-1                18 ctlNotifyMultiPart
1297 AD5B 65 AB                 DC W:Inval_rect-1              19 ctlWinStateChange (just inval)
1298 AD5D                       ENDP 
1299 AD5D
1300 AD5D
1301 AD5D              ;====================================================================
1302 AD5D              ;
1303 AD5D              ;          Test if given point is
1304 AD5D              ;          inside the enclosing RECT.
1305 AD5D              ;
1306 AD5D              ;   IN:    param = point to check, param = y, param+2 = x.
1307 AD5D              ;
1308 AD5D              ;  OUT:    a = check box part code of found part.
1309 AD5D              ;
1310 AD5D              ;  To get this far, the point must be inside the control's enclosing RECT.
1311 AD5D              ;  So, just return the part code to signal a hit.
1312 AD5D              ;
1313 AD5D              ;====================================================================
1314 AD5D              radioHit proc EXPORT 
1315 AD5D
1316 AD5D A9 04 00              lda   #RADIO_PART              Return part code in A.
1317 AD60
1318 AD60 60                    rts   
1319 AD61
1320 AD61                       ENDP 
1321 AD61
1322 AD61
1323 AD61              ;====================================================================
1324 AD61              ;
1325 AD61              ;          Draw a radio button.
1326 AD61              ;
1327 AD61              ;====================================================================
1328 AD61              radio_draw proc EXPORT 
1329 AD61
1330 AD61 A2 04 00              ldx   #4                       Radio button icon number.
1331 AD64 82 58 FE              brl   radio_check              Draw radio button.
1332 AD67
1333 AD67                       ENDP 
1334 AD67
1335 AD67
1336 AD67              ;====================================================================
1337 AD67              ;
1338 AD67              ;          Set a new value for a radio button.
1339 AD67              ;
1340 AD67              ;   IN:    Ctlptr =  pointer to control.
1341 AD67              ;          windptr = pointer of control's window.
1342 AD67              ;
1343 AD67              ;  OUT:    None.
1344 AD67              ;
1345 AD67              ;====================================================================
1346 AD67              radio_set proc EXPORT 
1347 AD67
1348 AD67              familyNum equ   work
1349 AD67              tempCtl  equ   familyNum+2
1350 AD67              ;
1351 AD67              ;
1352 AD67 20 61 AD              jsr   radio_draw               Draw the button in its new state.
1353 AD6A              ;
1354 AD6A              ;
1355 AD6A              ; --- Make sure two buttons in the same family are not on -------------
1356 AD6A              ;
1357 AD6A 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
1358 AD6D A0 12 00              ldy   #CtlValue                Is button being turned off?
1359 AD70 B7 05                 lda   [<Ctlptr],y
1360 AD72 AA                    tax                            (Set return flag.)
1361 AD73 F0 58                 beq   exit                     If yes, I don't have to worry about
1362 AD75              ;                                       other radio buttons in this family.
1363 AD75              ;
1364 AD75              ;
1365 AD75              ; --- Check if there are any buttons in this family on ---------------
1366 AD75              ;
1367 AD75 A5 01                 lda   <Ctlhand                 Save handle of this control.
1368 AD77 85 2F                 sta   <tempCtl
1369 AD79 A5 03                 lda   <Ctlhand+2
1370 AD7B 85 31                 sta   <tempCtl+2
1371 AD7D              ;
1372 AD7D A0 10 00              ldy   #CtlFlag                 Get this radio button's family number.
1373 AD80 B7 05                 lda   [<Ctlptr],y
1374 AD82 29 7F 00              and   #$007F
1375 AD85 85 2D                 sta   <familyNum
1376 AD87              ;
1377 AD87 A0 CA 00              ldy   #owControls              Get head of control list.
1378 AD8A B7 09                 lda   [<windptr],y
1379 AD8C 85 01                 sta   <Ctlhand
1380 AD8E C8                    iny   
1381 AD8F B7 09                 lda   [<windptr],y
1382 AD91 85 02                 sta   <Ctlhand+1               (And I know there must be at least
1383 AD93              ;                                       one control in the control list. )
1384 AD93              ;
1385 AD93 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
1386 AD96              ;
1387 AD96              ;
1388 AD96 20 CE AD     lop1     jsr   next_radio
1389 AD99 F0 32                 beq   exit                     Is no other radio button set?
1390 AD9B              ;
1391 AD9B A5 01                 lda   <Ctlhand                 Check if I found the one just set.
1392 AD9D C5 2F                 cmp   <tempCtl
1393 AD9F D0 0C                 bne   gotit
1394 ADA1 A5 02                 lda   <Ctlhand+1
1395 ADA3 C5 30                 cmp   <tempCtl+1
1396 ADA5 D0 06                 bne   gotit                    If not, I've found a family member on.
1397 ADA7              ;
1398 ADA7 20 7C A3              jsr   next_Ctl                 If yes, skip it, and start from there.
1399 ADAA D0 EA                 bne   lop1                     End of the line?
1400 ADAC
1401 ADAC 60                    rts   
1402 ADAD
1403 ADAD
1404 ADAD A0 12 00     gotit    ldy   #CtlValue                Turn the other radio button off.
1405 ADB0 A9 00 00              lda   #0
1406 ADB3 97 05                 sta   [<Ctlptr],y
1407 ADB5              ;
1408 ADB5 A0 10 00              ldy   #CtlFlag                 Redraw the radio button if visible.
1409 ADB8 B7 05                 lda   [<ctlptr],y
1410 ADBA 29 80 00              and   #CTL_INVIS
1411 ADBD D0 0E                 bne   exit
1412 ADBF              ;
1413 ADBF A0 50 00              ldy   #state                   Unhilte.
1414 ADC2 A9 00 00              lda   #0
1415 ADC5 97 41                 sta   [<data],y
1416 ADC7 20 2C A4              jsr   CMsetrect                Put enclosing RECT into 'rect'.
1417 ADCA 20 61 AD              jsr   radio_draw               Draw the button turned off.
1418 ADCD              ;
1419 ADCD 60           exit     rts   
1420 ADCE
1421 ADCE                       ENDP 
1422 ADCE
1423 ADCE
1424 ADCE              ;====================================================================
1425 ADCE              ;
1426 ADCE              ;          Find the next on radio button in a family.
1427 ADCE              ;
1428 ADCE              ;   IN:    Ctlhand = handle of Ctlptr.
1429 ADCE              ;          work = family number.
1430 ADCE              ;
1431 ADCE              ;  OUT:    Ctlptr = next on radio button in family, zero if none found.
1432 ADCE              ;          Ctlhand = handle of Ctlptr.
1433 ADCE              ;          Equal flag is TRUE if no control found.
1434 ADCE              ;          Equal flag is FALSE if control found.
1435 ADCE              ;
1436 ADCE              ;====================================================================
1437 ADCE              next_radio proc EXPORT 
1438 ADCE
1439 ADCE 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
1440 ADD1 A0 14 00     lop1     ldy   #Ctlproc                 Is the control a radio button?
1441 ADD4 B7 05                 lda   [<Ctlptr],y
1442 ADD6 D0 1F                 bne   next1
1443 ADD8 C8                    iny   
1444 ADD9 C8                    iny   
1445 ADDA B7 05                 lda   [<Ctlptr],y
1446 ADDC 29 FF 7F              and   #$7FFF                   ; ignore super control bit
1447 ADDF C9 00 04              cmp   #$0400
1448 ADE2 D0 13                 bne   next1
1449 ADE4              ;
1450 ADE4 A0 10 00              ldy   #CtlFlag                 Check for matching family number.
1451 ADE7 B7 05                 lda   [<Ctlptr],y
1452 ADE9 29 7F 00              and   #$007F
1453 ADEC C5 2D                 cmp   <work
1454 ADEE D0 07                 bne   next1
1455 ADF0              ;
1456 ADF0 A0 12 00              ldy   #CtlValue                Is it on?
1457 ADF3 B7 05                 lda   [<Ctlptr],y
1458 ADF5 D0 05                 bne   exit                     If yes, I've found it.
1459 ADF7              ;
1460 ADF7 20 7C A3     next1    jsr   next_Ctl                 Next control.
1461 ADFA D0 D5                 bne   lop1
1462 ADFC              ;
1463 ADFC 60           exit     rts   
1464 ADFD
1465 ADFD                       ENDP 
1466 ADFD
1467 ADFD
1468 ADFD                       title 'GROW_PROC' 
1469 ADFD              ;====================================================================
1470 ADFD              ;
1471 ADFD              ;          Grow box definition proc EXPORTedure.
1472 ADFD              ;
1473 ADFD              ;   IN:    a = task.
1474 ADFD              ;          Ctlptr = pointer to control.
1475 ADFD              ;          param = additional parameter.
1476 ADFD              ;
1477 ADFD              ;  OUT:    a = low word of returned value.
1478 ADFD              ;          x = high word of returned value.
1479 ADFD              ;
1480 ADFD              ;====================================================================
1481 ADFD              grow_proc  proc EXPORT 
1482 ADFD C9 14 00              cmp   #ctlWinStateChange+1
1483 AE00 90 03                 bcc   @1
1484 AE02 82 38 FA              brl   null_ret
1485 AE05              @1        
1486 AE05
1487 AE05 0A                    asl   a                        Compute index for dispatch.
1488 AE06 AA                    tax   
1489 AE07 7C 0A AE              jmp   (grow_tasks,x)
1490 AE0A
1491 AE0A 32 AE        grow_tasks DC W:draw_grow               0  Draw grow box.
1492 AE0C 3D A8                 DC W:null_ret                  1  Compute drag RECT.
1493 AE0E 69 AE                 DC W:test_grow                 2  Common hit test routine.
1494 AE10 EF AE                 DC W:init_grow                 3  Initialize just the color table.
1495 AE12 3D A8                 DC W:null_ret                  4  Dispose.
1496 AE14 32 AE                 DC W:draw_grow                 5  New value.
1497 AE16 3D A8                 DC W:null_ret                  6  Compute Thumber constrains.
1498 AE18 7B AE                 DC W:track_grow                7  Drag the indicator.
1499 AE1A 3D A8                 DC W:null_ret                  8  Auto action.
1500 AE1C 32 AE                 DC W:draw_grow                 9  New value.
1501 AE1E 3D A8                 DC W:null_ret                  10 Set min max.
1502 AE20 3D A8                 DC W:null_ret                  11 Move button.
1503 AE22 FF A8                 DC W:nor_size                  12 Return size of standard record.
1504 AE24 3D A8                 DC W:null_ret                  13 ctlHandleEvent
1505 AE26 3D A8                 DC W:null_ret                  14 ctlChangeTarget
1506 AE28 3D A8                 DC W:null_ret                  15 ctlChagneBounds
1507 AE2A 3D A8                 DC W:null_ret                  16 ctlWindChagneSize
1508 AE2C 3D A8                 DC W:null_ret                  17 ctlHandleTab
1509 AE2E 3D A8                 DC W:null_ret                  18 ctlNotifyMultiPart
1510 AE30 66 AB                 DC W:Inval_rect                19 ctlWinStateChange (just inval)
1511 AE32                       ENDP 
1512 AE32
1513 AE32
1514 AE32              ;====================================================================
1515 AE32              ;
1516 AE32              ;          Draw a grow box.
1517 AE32              ;
1518 AE32              ;   IN:    <param = 0 to draw entire control, state = 0.
1519 AE32              ;                   part code to draw just that part of the control.
1520 AE32              ;
1521 AE32              ;           state = 0 to draw part in 'param' as unhighlighted.
1522 AE32              ;                   2 to draw part in 'param' as highlighted.
1523 AE32              ;
1524 AE32              ;           active = $0000 if control is active.
1525 AE32              ;                    $FFFF if control is inactive, param = 0.
1526 AE32              ;
1527 AE32              ;====================================================================
1528 AE32              draw_grow proc EXPORT 
1529 AE32
1530 AE32 20 D8 B5              jsr   CheckForVis              If not visible, don't come back
1531 AE35 20 E8 B5              jsr   SetupColor
1532 AE38
1533 AE38 A0 50 00              ldy   #state
1534 AE3B B7 41                 lda   [<data],y
1535 AE3D 18                    clc   
1536 AE3E 69 02 00              adc   #simpNorBack
1537 AE41 A8                    tay   
1538 AE42 B7 11                 lda   [<colorPtr],y
1539 AE44 29 F0 00              and   #$00F0
1540 AE47 A8                    tay                            Pass color of interior.
1541 AE48 A7 11                 lda   [<colorPtr]              Pass color of frame.
1542 AE4A 29 F0 00              and   #$00F0
1543 AE4D 20 16 A3              jsr   drawRect                 Draw outline and interior.
1544 AE50              ;
1545 AE50              ;
1546 AE50 A0 4E 00              ldy   #active                  Is control inactive?
1547 AE53 B7 41                 lda   [<data],y
1548 AE55 30 11                 bmi   exit                     If inactive, don't draw icon.
1549 AE57              ;
1550 AE57 A2 10 00              ldx   #GROW_ICON
1551 AE5A 20 93 A3              jsr   get_csize                Get the size of the grow icon.
1552 AE5D              ;
1553 AE5D 20 E0 B2              jsr   center_hor               Center grow box horizontally.
1554 AE60 90 06                 bcc   exit                     Does the icon fix inside the RECT?
1555 AE62              ;
1556 AE62 A9 10 00              lda   #GROW_ICON
1557 AE65 82 60 FE              brl   draw_icon
1558 AE68              ;
1559 AE68 60           exit     rts   
1560 AE69
1561 AE69                       ENDP 
1562 AE69
1563 AE69
1564 AE69              ;====================================================================
1565 AE69              ;
1566 AE69              ;          Initialize grow box record.
1567 AE69              ;
1568 AE69              ;====================================================================
1569 AE69              test_grow proc EXPORT 
1570 AE69
1571 AE69 A0 10 00              ldy   #NewCtlRecord.ctlFlag
1572 AE6C B7 05                 lda   [ctlPtr],y
1573 AE6E 29 01 00              and   #$0001
1574 AE71 F0 04                 beq   NeverMind
1575 AE73
1576 AE73 A9 80 00              lda   #$80                     ; return a value that will force
1577 AE76 60                    rts                            ; us to do the tracking.
1578 AE77
1579 AE77
1580 AE77              NeverMind  
1581 AE77
1582 AE77 A9 0A 00              lda   #GROW_PART               Must be hit to get this far.
1583 AE7A
1584 AE7A 60                    rts   
1585 AE7B
1586 AE7B                       ENDP 
1587 AE7B
1588 AE7B
1589 AE7B              ;====================================================================
1590 AE7B              ;
1591 AE7B              ; track the grow box by calling the window manager
1592 AE7B              ;
1593 AE7B              ;====================================================================
1594 AE7B              track_grow proc 
1595 AE7B
1596 AE7B A5 29                 lda   param
1597 AE7D AA                    tax   
1598 AE7E F0 60                 beq   DoNothing
1599 AE80
1600 AE80
1601 AE80 48                    pha                            ; save the current origin
1602 AE81 48                    pha   
1603 AE82 48                    pha   
1604 AE83 48                    pha   
1605 AE84 3B                    tsc   
1606 AE85 1A                    inc   a
1607 AE86 F4 00 00              pea   0000
1608 AE89 48                    pha   
1609 AE8A A2 04 20 22           _GetPortRect 
1610 AE91
1611 AE91 A9 00 00              lda   #0                       ; set origin to zero (only works with zero origin)
1612 AE94 48                    pha   
1613 AE95 48                    pha   
1614 AE96 A2 04 23 22           _SetOrigin 
1615 AE9D
1616 AE9D              ;
1617 AE9D              ; See if any minimum size is in ctlData field.  zero means use default.
1618 AE9D              ;
1619 AE9D A0 1C 00              ldy   #NewCtlRecord.ctlData
1620 AEA0 B7 05                 lda   [ctlPtr],y
1621 AEA2 D0 03                 bne   @1
1622 AEA4 A9 32 00              lda   #50                      ; minimum y
1623 AEA7 AA           @1       tax   
1624 AEA8 C8                    iny   
1625 AEA9 C8                    iny   
1626 AEAA B7 05                 lda   [ctlPtr],y
1627 AEAC D0 03                 bne   @2
1628 AEAE A9 82 00              lda   #130                     ; minimum x
1629 AEB1              @2        
1630 AEB1 48                    pha                            ; space for result
1631 AEB2 48                    pha   
1632 AEB3 48                    pha                            ; use (30,10) more in each direction, so we end up being the
1633 AEB4 DA                    phx                            ;..same as task master.
1634 AEB5
1635 AEB5 48                    pha                            ; read the mouse in global coordinates
1636 AEB6 48                    pha   
1637 AEB7 48                    pha   
1638 AEB8 A2 03 17 22           _ReadMouse 
1639 AEBF 68                    pla                            ; ignore the mode word, leave x and y on stack.
1640 AEC0
1641 AEC0 20 E1 AE              jsr   PushWindowPtr
1642 AEC3 A2 0E 1B 22           _GrowWindow 
1643 AECA
1644 AECA 20 E1 AE              jsr   PushWindowPtr
1645 AECD A2 0E 1C 22           _SizeWindow 
1646 AED4
1647 AED4 A2 04 23 22           _SetOrigin                     ; restore origin to top left of original port rect
1648 AEDB 68                    pla                            ; remove bottom right from stack
1649 AEDC 68                    pla   
1650 AEDD
1651 AEDD A5 29                 lda   param                    ; return the part code to indicate that
1652 AEDF AA                    tax                            ; that we handled the work.  X indicates not aborted.
1653 AEE0
1654 AEE0
1655 AEE0 60           DoNothing rts   
1656 AEE1
1657 AEE1
1658 AEE1
1659 AEE1              PushWindowPtr  
1660 AEE1 FA                    plx   
1661 AEE2 A0 06 00              ldy   #NewCtlRecord.ctlOwner+2
1662 AEE5 B7 05                 lda   [ctlPtr],y
1663 AEE7 48                    pha   
1664 AEE8 88                    dey   
1665 AEE9 88                    dey   
1666 AEEA B7 05                 lda   [ctlPtr],y
1667 AEEC 48                    pha   
1668 AEED DA                    phx   
1669 AEEE 60                    rts   
1670 AEEF
1671 AEEF
1672 AEEF
1673 AEEF                       ENDP 
1674 AEEF
1675 AEEF
1676 AEEF              ;====================================================================
1677 AEEF              ;
1678 AEEF              ;          Init the Grow Control
1679 AEEF              ;
1680 AEEF              ; Change History
1681 AEEF              ;
1682 AEEF              ; 10 Oct 88         Steven Glass
1683 AEEF              ;
1684 AEEF              ; Added code to make this work with NewControl2.
1685 AEEF              ;
1686 AEEF              ;====================================================================
1687 AEEF              init_grow proc EXPORT 
1688 AEEF
1689 AEEF A0 16 00              ldy   #NewCtlRecord.ctlProc+2
1690 AEF2 B7 05                 lda   [ctlPtr],y
1691 AEF4 10 1E                 bpl   OldWay
1692 AEF6
1693 AEF6              ;-----------------------------------------------------------
1694 AEF6              ;
1695 AEF6              ; This is being called from NewControl2.  This means that
1696 AEF6              ; Param holds pointer to the template.  CtlColor is not set
1697 AEF6              ; up.
1698 AEF6              ;
1699 AEF6              ; We fiddle with the data as follows:
1700 AEF6              ;    Check the pcount to see if there is a color table
1701 AEF6              ;    If YES, copy ref to CtlColor
1702 AEF6              ;    Fall into old code.
1703 AEF6              ;
1704 AEF6 A0 00 00              ldy   #GrowTemplate.pcount
1705 AEF9 B7 29                 lda   [param],y
1706 AEFB C9 07 00              cmp   #7
1707 AEFE D0 14                 bne   NoColorTable
1708 AF00
1709 AF00 A0 1A 00              ldy   #GrowTemplate.ColorRef
1710 AF03 B7 29                 lda   [param],y
1711 AF05 AA                    tax   
1712 AF06 C8                    iny   
1713 AF07 C8                    iny   
1714 AF08 B7 29                 lda   [param],y
1715 AF0A A0 26 00              ldy   #NewCtlRecord.CtlColor+2
1716 AF0D 97 05                 sta   [ctlPtr],y
1717 AF0F 88                    dey   
1718 AF10 88                    dey   
1719 AF11 8A                    txa   
1720 AF12 97 05                 sta   [ctlPtr],y
1721 AF14
1722 AF14              NoColorTable  
1723 AF14
1724 AF14              OldWay    
1725 AF14
1726 AF14 A0 26 00              ldy   #CtlColor+2              Color table pointer already there?
1727 AF17 B7 05                 lda   [<Ctlptr],y
1728 AF19 88                    dey   
1729 AF1A 88                    dey   
1730 AF1B 17 05                 ora   [<Ctlptr],y
1731 AF1D D0 0C                 bne   exit
1732 AF1F              ;
1733 AF1F A9 B7 A4              lda   #grow_color
1734 AF22 97 05                 sta   [<Ctlptr],y              y-reg still set to #CtlColor
1735 AF24 C8                    iny   
1736 AF25 C8                    iny   
1737 AF26 A9 FD 00              lda   #^grow_color
1738 AF29 97 05                 sta   [<Ctlptr],y
1739 AF2B              ;
1740 AF2B 60           exit     rts   
1741 AF2C
1742 AF2C                       ENDP 
1743 AF2C
1744 AF2C
1745 AF2C                       title 'SCROLL_PROC' 
1746 AF2C              ;====================================================================
1747 AF2C              ;
1748 AF2C              ;          Main line Scroll Bar handler.
1749 AF2C              ;
1750 AF2C              ;   IN:    a = task.
1751 AF2C              ;          Ctlptr = pointer to control.
1752 AF2C              ;          param = additional parameter.
1753 AF2C              ;
1754 AF2C              ;  OUT:    a = low word of returned value.
1755 AF2C              ;          x = high word of returned value.
1756 AF2C              ;
1757 AF2C              ;====================================================================
1758 AF2C              scroll_proc  proc EXPORT 
1759 AF2C C9 14 00              cmp   #ctlWinStateChange+1
1760 AF2F 90 03                 bcc   @1
1761 AF31 82 09 F9              brl   null_ret
1762 AF34              @1        
1763 AF34
1764 AF34 0A                    asl   a                        Compute index for dispatch.
1765 AF35 AA                    tax   
1766 AF36 7C 39 AF              jmp   (scroll_task_list,x)     Complete the task.
1767 AF39              ;
1768 AF39              ;
1769 AF39                       export scroll_task_list 
1770 AF39 31 B1        scroll_task_list DC W:scroll_draw       0 Draw.
1771 AF3B 3D A8                 DC W:null_ret                  1 Compute drag RECT.
1772 AF3D B1 B0                 DC W:scroll_hit                2 Common hit test routine.
1773 AF3F 73 AF                 DC W:scroll_init               3 Initialize the control.
1774 AF41 3D A8                 DC W:null_ret                  4 Dispose.
1775 AF43 3D A8                 DC W:null_ret                  5 Called after drag is completed.
1776 AF45 3D A8                 DC W:null_ret                  6 Setup for dragging.
1777 AF47 3D A8                 DC W:null_ret                  7 Perform dragging.
1778 AF49 3D A8                 DC W:null_ret                  8 Auto track.
1779 AF4B 60 B3                 DC W:move_thumb                9 New value.
1780 AF4D F5 B2                 DC W:newView                   10 Called with new Min and Max values.
1781 AF4F 8D B4                 DC W:move_bar                  11 Move scroll bar.
1782 AF51 61 AF                 DC W:rec_size                  12 Return size of scroll bar record.
1783 AF53 3D A8                 DC W:null_ret                  13 ctlhandleEvent
1784 AF55 3D A8                 DC W:null_ret                  14 ctlChangeTarget
1785 AF57 3D A8                 DC W:null_ret                  15 ctlChagneBounds
1786 AF59 3D A8                 DC W:null_ret                  16 ctlWindChagneSize
1787 AF5B 3D A8                 DC W:null_ret                  17 ctlHandleTab
1788 AF5D 3D A8                 DC W:null_ret                  18 ctlNotifyMultiPart
1789 AF5F 66 AB                 DC W:Inval_rect                19 ctlWinStateChange (just inval)
1790 AF61
1791 AF61                       ENDP 
1792 AF61
1793 AF61                       title 'SCROLL_PROC -- rec_size' 
1794 AF61              ;====================================================================
1795 AF61              ;
1796 AF61              ;          Return size of required record.
1797 AF61              ;
1798 AF61              ;====================================================================
1799 AF61              rec_size proc EXPORT 
1800 AF61
1801 AF61 A5 29                 lda   param
1802 AF63 05 2B                 ora   param+2
1803 AF65 F0 05                 beq   OldSize
1804 AF67
1805 AF67 A9 40 00              lda   #SuperCtlSize
1806 AF6A 80 03                 bra   ReturnIt
1807 AF6C
1808 AF6C              OldSize   
1809 AF6C
1810 AF6C A9 38 00              lda   #PageRegion+8            Size of scroll bar record.
1811 AF6F
1812 AF6F              ReturnIt  
1813 AF6F A2 00 00              ldx   #0                       High word of size.
1814 AF72
1815 AF72 60                    rts   
1816 AF73
1817 AF73                       ENDP 
1818 AF73
1819 AF73
1820 AF73                       title 'SCROLL_PROC -- scroll_init' 
1821 AF73              ;====================================================================
1822 AF73              ;
1823 AF73              ;          Initialize scroll bar.
1824 AF73              ;
1825 AF73              ; Change History
1826 AF73              ;
1827 AF73              ; 24 Jul 88         Steven Glass
1828 AF73              ;
1829 AF73              ; Added control value validation.
1830 AF73              ;
1831 AF73              ;
1832 AF73              ; 10 Oct 88         Steven Glass
1833 AF73              ;
1834 AF73              ; Added code to translate NewCtl2 inputs to NewCtl inputs.
1835 AF73              ;
1836 AF73              ; 07 Dec 88         STeven Glass & Mensch
1837 AF73              ;
1838 AF73              ; Fixed bug with color table ref's and control templates.  The
1839 AF73              ; code bne'd when it should have beq'd for pCount of 9.
1840 AF73              ;
1841 AF73              ;====================================================================
1842 AF73              scroll_init proc EXPORT 
1843 AF73
1844 AF73 A0 16 00              ldy   #NewCtlRecord.ctlProc+2
1845 AF76 B7 05                 lda   [ctlPtr],y
1846 AF78 10 37                 bpl   OldWay
1847 AF7A
1848 AF7A              ;-----------------------------------------------------------
1849 AF7A              ;
1850 AF7A              ; This is being called from NewControl2.  This means that
1851 AF7A              ; Param holds pointer to the template.  CtlColor is not set
1852 AF7A              ; up.  DataSize and ViewSize are not in Param.
1853 AF7A              ;
1854 AF7A              ; We fiddle with the data as follows:
1855 AF7A              ;    Copy the intital thumb value from template to record.
1856 AF7A              ;    Check the pcount to see if there is a color table
1857 AF7A              ;    If YES, copy ref to CtlColor
1858 AF7A              ;    Copy DataSize and ViewSize to Param
1859 AF7A              ;    Fall into old code.
1860 AF7A              ;
1861 AF7A
1862 AF7A A0 1E 00              ldy   #ScrollTemplate.InitialThumb
1863 AF7D B7 29                 lda   [param],y
1864 AF7F A0 12 00              ldy   #NewCtlRecord.ctlValue
1865 AF82 97 05                 sta   [ctlPtr],y
1866 AF84
1867 AF84 A0 00 00              ldy   #ScrollTemplate.pcount   is there a color table
1868 AF87 B7 29                 lda   [param],y
1869 AF89 C9 09 00              cmp   #9
1870 AF8C F0 14                 beq   NoColorTable
1871 AF8E
1872 AF8E A0 20 00              ldy   #ScrollTemplate.ColorRef yes, put its ref in.
1873 AF91 B7 29                 lda   [param],y
1874 AF93 AA                    tax   
1875 AF94 C8                    iny   
1876 AF95 C8                    iny   
1877 AF96 B7 29                 lda   [param],y
1878 AF98 A0 26 00              ldy   #NewCtlRecord.CtlColor+2
1879 AF9B 97 05                 sta   [ctlPtr],y
1880 AF9D 88                    dey   
1881 AF9E 88                    dey   
1882 AF9F 8A                    txa   
1883 AFA0 97 05                 sta   [ctlPtr],y
1884 AFA2
1885 AFA2              NoColorTable                            ;finished with color table
1886 AFA2
1887 AFA2 A0 1A 00              ldy   #ScrollTemplate.DataSize ;fix param and fall into old way
1888 AFA5 B7 29                 lda   [param],y
1889 AFA7 AA                    tax   
1890 AFA8 A0 1C 00              ldy   #ScrollTemplate.ViewSize
1891 AFAB B7 29                 lda   [param],y
1892 AFAD 85 29                 sta   param
1893 AFAF 86 2B                 stx   param+2
1894 AFB1
1895 AFB1
1896 AFB1              OldWay    
1897 AFB1              ;
1898 AFB1              ; --- Validate the maximum value ------
1899 AFB1              ;
1900 AFB1 A5 2B                 lda   param+2                  ; Max allowable value is Max-View
1901 AFB3 38                    sec   
1902 AFB4 E5 29                 sbc   param
1903 AFB6 A0 12 00              ldy   #Ctlvalue                ; compare to the current value
1904 AFB9 D7 05                 cmp   [<Ctlptr],y              ; from control record
1905 AFBB B0 07                 bcs   @MaxOK                   ; ok
1906 AFBD B7 05                 lda   [<Ctlptr],y              ; Bump max so it is equal to value+view
1907 AFBF 18                    clc   
1908 AFC0 65 29                 adc   <param
1909 AFC2 85 2B                 sta   <param+2                 ; adjust the max value.
1910 AFC4 C5 29        @MaxOK   cmp   <param                   ; is it greater than the min value?
1911 AFC6              ;
1912 AFC6              ; --- Set view and data size -----------------------
1913 AFC6              ;
1914 AFC6 A0 1C 00              ldy   #Ctldata
1915 AFC9 A5 29                 lda   <param
1916 AFCB 97 05                 sta   [<Ctlptr],y
1917 AFCD C8                    iny   
1918 AFCE C8                    iny   
1919 AFCF A5 2B                 lda   <param+2
1920 AFD1 97 05                 sta   [<Ctlptr],y
1921 AFD3              ;
1922 AFD3              ;
1923 AFD3              ; --- Set default color table pointer --------------
1924 AFD3              ;
1925 AFD3 A0 25 00              ldy   #CtlColor+1
1926 AFD6 B7 05                 lda   [<Ctlptr],y
1927 AFD8 88                    dey   
1928 AFD9 17 05                 ora   [<Ctlptr],y
1929 AFDB D0 0C                 bne   skip1
1930 AFDD              ;
1931 AFDD A9 A7 A4              lda   #scroll_color
1932 AFE0 97 05                 sta   [<Ctlptr],y
1933 AFE2 C8                    iny   
1934 AFE3 C8                    iny   
1935 AFE4 A9 FD 00              lda   #scroll_color>>16
1936 AFE7 97 05                 sta   [<Ctlptr],y
1937 AFE9              ;
1938 AFE9              ;
1939 AFE9              ; --- Set sizes --------------------------------------------
1940 AFE9              ;
1941 AFE9 20 2C A4     skip1    jsr   CMsetrect                Put enclosing RECT into 'rect'.
1942 AFEC              ;
1943 AFEC A2 52 00              ldx   #uArrowH                 Use up arrow for vertical bar,
1944 AFEF A0 10 00              ldy   #CtlFlag
1945 AFF2 B7 05                 lda   [<Ctlptr],y
1946 AFF4 29 10 00              and   #DIR_SCROLL
1947 AFF7 F0 03                 beq   ok1
1948 AFF9 A2 5A 00              ldx   #lArrowH                 and left arrow for horizontal bars.
1949 AFFC 9B           ok1      txy   
1950 AFFD B7 41                 lda   [<data],y                Height of arrow icon,
1951 AFFF 18                    clc   
1952 B000 69 03 00              adc   #3                       plus leading,
1953 B003 A0 21 00              ldy   #rect2+y2
1954 B006 97 41                 sta   [<data],y                equals total size.
1955 B008              ;
1956 B008 9B                    txy   
1957 B009 C8                    iny                            Width of arrow icon,
1958 B00A C8                    iny   
1959 B00B B7 41                 lda   [<data],y
1960 B00D 18                    clc   
1961 B00E 69 08 00              adc   #8                       plus leading,
1962 B011 A0 23 00              ldy   #rect2+x2
1963 B014 97 41                 sta   [<data],y                equals total size.
1964 B016              ;
1965 B016              ;
1966 B016              ; ------ Set default height --------------------------------------
1967 B016              ;
1968 B016 A5 19                 lda   <rect+y2                 Is it set?
1969 B018 D0 0F                 bne   skip2
1970 B01A              ;
1971 B01A A5 15                 lda   <rect+y1
1972 B01C 18                    clc   
1973 B01D A0 21 00              ldy   #rect2+y2
1974 B020 77 41                 adc   [<data],y
1975 B022 85 19                 sta   <rect+y2
1976 B024 A0 0C 00              ldy   #CtlRect+y2
1977 B027 97 05                 sta   [<Ctlptr],y              Set height of enclosing RECT.
1978 B029              ;
1979 B029 A5 1B        skip2    lda   <rect+x2                 Is it set?
1980 B02B D0 0F                 bne   skip3
1981 B02D              ;
1982 B02D A5 17                 lda   <rect+x1
1983 B02F 18                    clc   
1984 B030 A0 23 00              ldy   #rect2+x2
1985 B033 77 41                 adc   [<data],y
1986 B035 85 1B                 sta   <rect+x2
1987 B037 A0 0E 00              ldy   #CtlRect+x2
1988 B03A 97 05                 sta   [<Ctlptr],y              Set width of enclosing RECT.
1989 B03C              ;
1990 B03C              ;
1991 B03C              ; ------ Set page region, by subtracting arrows from enclosing RECT ------
1992 B03C              ;
1993 B03C A0 10 00     skip3    ldy   #CtlFlag
1994 B03F B7 05                 lda   [<Ctlptr],y
1995 B041 48                    pha   
1996 B042 29 01 00              and   #UP_FLAG
1997 B045 F0 0A                 beq   skip10
1998 B047              ;
1999 B047 A5 15                 lda   <rect+y1
2000 B049 18                    clc   
2001 B04A A0 21 00              ldy   #rect2+y2                Add height of icon plus leading.
2002 B04D 77 41                 adc   [<data],y
2003 B04F 85 15                 sta   <rect+y1
2004 B051              ;
2005 B051 A3 01        skip10   lda   1,s
2006 B053 29 02 00              and   #DOWN_FLAG
2007 B056 F0 0A                 beq   skip11
2008 B058              ;
2009 B058 A5 19                 lda   <rect+y2
2010 B05A 38                    sec   
2011 B05B A0 21 00              ldy   #rect2+y2
2012 B05E F7 41                 sbc   [<data],y
2013 B060 85 19                 sta   <rect+y2
2014 B062              ;
2015 B062 A3 01        skip11   lda   1,s
2016 B064 29 04 00              and   #LEFT_FLAG
2017 B067 F0 0A                 beq   skip12
2018 B069              ;
2019 B069 A5 17                 lda   <rect+x1
2020 B06B 18                    clc   
2021 B06C A0 23 00              ldy   #rect2+x2
2022 B06F 77 41                 adc   [<data],y
2023 B071 85 17                 sta   <rect+x1
2024 B073              ;
2025 B073 68           skip12   pla   
2026 B074 29 08 00              and   #RIGHT_FLAG
2027 B077 F0 0A                 beq   skip13
2028 B079              ;
2029 B079 A5 1B                 lda   <rect+x2
2030 B07B 38                    sec   
2031 B07C A0 23 00              ldy   #rect2+x2
2032 B07F F7 41                 sbc   [<data],y
2033 B081 85 1B                 sta   <rect+x2
2034 B083              ;
2035 B083 A0 36 00     skip13   ldy   #PageRegion+x2           Initialize page region.
2036 B086 20 A5 B0              jsr   to_Ctl                   Move 'rect' into page region.
2037 B089              ;
2038 B089 20 72 A1              jsr   pushrect                 Indent thumber from page region.
2039 B08C 20 64 A1              jsr   pushVvert_pen
2040 B08F F4 01 00              pea   1
2041 B092 A2 04 4C 22           _InsetRect 
2042 B099              ;
2043 B099 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
2044 B09C A0 2E 00              ldy   #Thumb+x2
2045 B09F 20 A5 B0              jsr   to_Ctl                   Move 'rect' into thumber RECT.
2046 B0A2              ;
2047 B0A2              ;
2048 B0A2              ; --- Set thumber position ---------------------------
2049 B0A2              ;
2050 B0A2 82 3C 03              brl   new_thumb
2051 B0A5
2052 B0A5
2053 B0A5
2054 B0A5
2055 B0A5              ;====================================================================
2056 B0A5              ;
2057 B0A5              ;          Move 'rect' into control RECT.
2058 B0A5              ;
2059 B0A5              ;  IN:     y = offset into record plus x2.
2060 B0A5              ;
2061 B0A5              ;====================================================================
2062 B0A5              to_Ctl    
2063 B0A5 A2 06 00              ldx   #x2
2064 B0A8 B5 15        lop1     lda   <rect,x
2065 B0AA 97 05                 sta   [<Ctlptr],y
2066 B0AC 88                    dey                            Anything for some bytes.
2067 B0AD CA                    dex   
2068 B0AE 10 F8                 bpl   lop1
2069 B0B0
2070 B0B0 60                    rts   
2071 B0B1
2072 B0B1
2073 B0B1                       ENDP 
2074 B0B1
2075 B0B1
2076 B0B1
2077 B0B1
2078 B0B1                       title 'SCROLL_PROC -- scroll_hit' 
2079 B0B1              ;====================================================================
2080 B0B1              ;
2081 B0B1              ;          Check hit on scroll bar.
2082 B0B1              ;
2083 B0B1              ;   IN:    Ctlptr = pointer to scroll bar record.
2084 B0B1              ;          param = y coordinate to check.
2085 B0B1              ;          param+2 = x coordinate to check.
2086 B0B1              ;
2087 B0B1              ;  OUT:    a = 0 if no hit.
2088 B0B1              ;              5 if on up arrow.
2089 B0B1              ;              6 if on down arrow.
2090 B0B1              ;              7 if on page up region.
2091 B0B1              ;              8 if on page down region.
2092 B0B1              ;            129 if on thumber.
2093 B0B1              ;
2094 B0B1              ;====================================================================
2095 B0B1              scroll_hit proc EXPORT 
2096 B0B1
2097 B0B1 A0 1C 00              ldy   #CtlData
2098 B0B4 B7 05                 lda   [<Ctlptr],y              Total view.
2099 B0B6 C8                    iny   
2100 B0B7 C8                    iny   
2101 B0B8 D7 05                 cmp   [<Ctlptr],y              Total data area.
2102 B0BA 90 04                 bcc   ok1
2103 B0BC              ;
2104 B0BC A9 00 00              lda   #0                       No hit anywhere if maxed out.
2105 B0BF
2106 B0BF 60                    rts   
2107 B0C0
2108 B0C0 A0 30 00     ok1      ldy   #PageRegion              Check page region.
2109 B0C3 20 1A B1              jsr   check_pt
2110 B0C6 F0 31                 beq   next1
2111 B0C8
2112 B0C8 A0 28 00              ldy   #Thumb                   Check thumber.
2113 B0CB 20 1A B1              jsr   check_pt
2114 B0CE A2 81 00              ldx   #THUMB_PART              Part code, just in case.
2115 B0D1 A8                    tay                            Was it a hit?
2116 B0D2 D0 44                 bne   got_it
2117 B0D4              ;
2118 B0D4              ; --- Must be in page region, up or down? -----------------
2119 B0D4              ;
2120 B0D4 A2 07 00              ldx   #UPP_PART                Page up part code.
2121 B0D7 A0 10 00              ldy   #CtlFlag
2122 B0DA B7 05                 lda   [<Ctlptr],y
2123 B0DC 29 10 00              and   #DIR_SCROLL              Vertical or horizontal bar?
2124 B0DF D0 0C                 bne   horizontal
2125 B0E1              ;
2126 B0E1 A5 29                 lda   <param                   Get y coordinate.
2127 B0E3 A0 28 00              ldy   #Thumb+y1
2128 B0E6 D7 05                 cmp   [<Ctlptr],y
2129 B0E8 90 2E                 bcc   got_it
2130 B0EA E8                    inx                            Page down part code.
2131 B0EB 80 2B                 bra   got_it                   Must be page down.
2132 B0ED              ;
2133 B0ED              ;
2134 B0ED A5 2B        horizontal lda   <param+2               Get x coordinate.
2135 B0EF A0 2A 00              ldy   #Thumb+x1
2136 B0F2 D7 05                 cmp   [<Ctlptr],y
2137 B0F4 90 22                 bcc   got_it
2138 B0F6 E8                    inx                            Page down part code.
2139 B0F7 80 1F                 bra   got_it                   Must be page down.
2140 B0F9              ;
2141 B0F9              ;
2142 B0F9              ; --- Must be in an arrow box ------------------------------
2143 B0F9              ;
2144 B0F9 A2 05 00     next1    ldx   #UP_PART
2145 B0FC              ;
2146 B0FC A0 30 00              ldy   #PageRegion+y1
2147 B0FF A5 29                 lda   <param                   Get y coordinate.
2148 B101 D7 05                 cmp   [<Ctlptr],y
2149 B103 90 13                 bcc   got_it
2150 B105              ;
2151 B105 E8                    inx                            Down arrow part code.
2152 B106              ;
2153 B106 A0 34 00              ldy   #PageRegion+y2
2154 B109 D7 05                 cmp   [<Ctlptr],y
2155 B10B B0 0B                 bcs   got_it
2156 B10D              ;
2157 B10D CA                    dex                            Back to up arrow.
2158 B10E              ;
2159 B10E A0 32 00              ldy   #PageRegion+x1
2160 B111 A5 2B                 lda   <param+2                 Get x coordinate.
2161 B113 D7 05                 cmp   [<Ctlptr],y
2162 B115 90 01                 bcc   got_it
2163 B117
2164 B117 E8                    inx                            Down arrow part code.
2165 B118
2166 B118 8A           got_it   txa   
2167 B119
2168 B119 60                    rts   
2169 B11A              ;
2170 B11A              ;
2171 B11A              ;   IN:    y = offset into record to check + x2.
2172 B11A              ;
2173 B11A                       EXPORT check_pt 
2174 B11A              check_pt                                ;
2175 B11A              ;
2176 B11A 48                    pha                            Space for result.
2177 B11B A9 29 00              lda   #param
2178 B11E 20 75 A1              jsr   pushzpage                Pass pointer of point to check.
2179 B121 98                    tya   
2180 B122 20 35 99              jsr   pushrecord               Pass pointer of RECT to check.
2181 B125 A2 04 4F 22           _PtInRect 
2182 B12C 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
2183 B12F 68                    pla   
2184 B130 60                    rts   
2185 B131              ;
2186 B131                       ENDP 
2187 B131
2188 B131
2189 B131                       title 'SCROLL_PROC -- scroll_draw' 
2190 B131              ;====================================================================
2191 B131              ;
2192 B131              ;          Draw a scroll bar.
2193 B131              ;
2194 B131              ;   IN:    Ctlptr = control pointer.
2195 B131              ;          param = part to draw.
2196 B131              ;
2197 B131              ;====================================================================
2198 B131              scroll_draw proc EXPORT 
2199 B131
2200 B131 20 D8 B5              jsr   CheckForVis              If not vis, don't come back.
2201 B134
2202 B134 20 E8 B5              jsr   SetupColor
2203 B137
2204 B137 A5 29                 lda   <param                   Get part code.
2205 B139 29 7F 00              and   #$7F
2206 B13C 0A                    asl   a
2207 B13D AA                    tax   
2208 B13E 7C 41 B1              jmp   (part_list,x)
2209 B141              ;
2210 B141              ;
2211 B141 53 B1        part_list DC W:draw_all                 0 Draw entire control.
2212 B143 48 B2                 DC W:draw_thumb                1 Draw thumber.
2213 B145 00 00                 DC W:0                         2
2214 B147 00 00                 DC W:0                         3
2215 B149 00 00                 DC W:0                         4
2216 B14B C2 B1                 DC W:draw_up1                  5 Draw up arrow.
2217 B14D D8 B1                 DC W:draw_down1                6 Draw down arrow.
2218 B14F 3D A8                 DC W:null_ret                  7 Draw page region.
2219 B151 3D A8                 DC W:null_ret                  8 Draw page region.
2220 B153              ;
2221 B153              ;
2222 B153              ;= = = = = = = = = = = = = = = = = = = = = = = = =
2223 B153              ;          Draw entire scroll bar.
2224 B153              ;= = = = = = = = = = = = = = = = = = = = = = = = =
2225 B153              ;
2226 B153 A0 4E 00     draw_all ldy   #active
2227 B156 B7 41                 lda   [<data],y                Is control inactive?
2228 B158 10 11                 bpl   skip100
2229 B15A              ;
2230 B15A              ; --- Draw an inactive scroll bar --------------------------
2231 B15A              ;
2232 B15A A0 0E 00              ldy   #InactiveColor           Inactive color.
2233 B15D B7 11                 lda   [<colorPtr],y
2234 B15F 29 F0 00              and   #$00F0
2235 B162 A8                    tay                            Pass interior color.
2236 B163 A7 11                 lda   [<colorPtr]              Pass frame color.
2237 B165 29 F0 00              and   #$00F0
2238 B168 82 AB F1              brl   drawrect                 Draw and exit.
2239 B16B              ;
2240 B16B              ;
2241 B16B              ; --- Draw an active scroll bar -----------------------------
2242 B16B              ;
2243 B16B 20 9D B1     skip100  jsr   inner_scroll             Draw interior of scroll bar.
2244 B16E              ;
2245 B16E 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
2246 B171 A0 10 00              ldy   #CtlFlag
2247 B174 B7 05                 lda   [<Ctlptr],y
2248 B176 48                    pha   
2249 B177 29 01 00              and   #UP_FLAG                 Up arrow?
2250 B17A F0 03                 beq   next100
2251 B17C              ;
2252 B17C 20 CF B1              jsr   draw_up2                 Draw up arrow.
2253 B17F              ;
2254 B17F A3 01        next100  lda   1,s
2255 B181 29 02 00              and   #DOWN_FLAG               Down arrow?
2256 B184 F0 03                 beq   next101
2257 B186              ;
2258 B186 20 E5 B1              jsr   draw_down2               Draw down arrow.
2259 B189              ;
2260 B189 A3 01        next101  lda   1,s
2261 B18B 29 04 00              and   #LEFT_FLAG               Left arrow?
2262 B18E F0 03                 beq   next102
2263 B190              ;
2264 B190 20 EE B1              jsr   draw_left2               Draw left arrow.
2265 B193              ;
2266 B193 68           next102  pla   
2267 B194 29 08 00              and   #RIGHT_FLAG              Right arrow?
2268 B197 F0 03                 beq   exit100
2269 B199              ;
2270 B199 82 5B 00              brl   draw_right2              Draw right arrow.
2271 B19C              ;
2272 B19C 60           exit100  rts   
2273 B19D              ;
2274 B19D              ;
2275 B19D                       EXPORT inner_scroll 
2276 B19D              inner_scroll                            ;
2277 B19D              ;
2278 B19D 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
2279 B1A0 A0 1C 00              ldy   #CtlData
2280 B1A3 B7 05                 lda   [<Ctlptr],y              Total view.
2281 B1A5 C8                    iny   
2282 B1A6 C8                    iny   
2283 B1A7 D7 05                 cmp   [<Ctlptr],y              Total data area.
2284 B1A9 90 0E                 bcc   ok100                    Everything in view?
2285 B1AB              ;
2286 B1AB A0 4E 00              ldy   #active                  Set active flag for arrows.
2287 B1AE A9 FF FF              lda   #$FFFF
2288 B1B1 97 41                 sta   [<data],y
2289 B1B3              ;
2290 B1B3 A0 08 00              ldy   #ThumbNorColor           Use thumber's color to draw page region.
2291 B1B6 82 47 00              brl   draw_page
2292 B1B9              ;
2293 B1B9 A0 0C 00     ok100    ldy   #PageRgnColor            Page region's color and pattern.
2294 B1BC 20 00 B2              jsr   draw_page                Draw page region.
2295 B1BF              ;
2296 B1BF 82 86 00              brl   draw_thumb               Draw thumber.
2297 B1C2              ;
2298 B1C2              ;
2299 B1C2              ;
2300 B1C2              ;= = = = = = = = = = = = = = = = =
2301 B1C2              ;          Draw up arrow.
2302 B1C2              ;= = = = = = = = = = = = = = = = =
2303 B1C2              ;
2304 B1C2 20 E2 A1     draw_up1 jsr   dereference              Ctlptr = (Ctlhand).
2305 B1C5 A0 10 00              ldy   #CtlFlag                 Vertical or horizontal?
2306 B1C8 B7 05                 lda   [<Ctlptr],y
2307 B1CA 29 10 00              and   #DIR_SCROLL
2308 B1CD D0 1F                 bne   draw_left2
2309 B1CF              ;
2310 B1CF 20 62 B2     draw_up2 jsr   up_box                   Draw up arrow box.
2311 B1D2              ;
2312 B1D2 A2 08 00              ldx   #UP_ARROW                Up arrow pattern index.
2313 B1D5 82 E3 00              brl   draw_arrow2
2314 B1D8              ;
2315 B1D8              ;
2316 B1D8              ;= = = = = = = = = = = = = = = = = = =
2317 B1D8              ;          Draw down arrow.
2318 B1D8              ;= = = = = = = = = = = = = = = = = = =
2319 B1D8              ;
2320 B1D8 20 E2 A1     draw_down1 jsr   dereference            Ctlptr = (Ctlhand).
2321 B1DB A0 10 00              ldy   #CtlFlag                 Vertical or horizontal?
2322 B1DE B7 05                 lda   [<Ctlptr],y
2323 B1E0 29 10 00              and   #DIR_SCROLL
2324 B1E3 D0 12                 bne   draw_right2
2325 B1E5              ;
2326 B1E5 20 72 B2     draw_down2 jsr   down_box               Draw down arrow box.
2327 B1E8              ;
2328 B1E8 A2 0A 00              ldx   #DOWN_ARROW              Down arrow pattern index.
2329 B1EB 82 CD 00              brl   draw_arrow2
2330 B1EE              ;
2331 B1EE              ;
2332 B1EE              ;= = = = = = = = = = = = = = = = = =
2333 B1EE              ;          Draw left arrow.  
2334 B1EE              ;= = = = = = = = = = = = = = = = = =
2335 B1EE              ;
2336 B1EE 20 82 B2     draw_left2 jsr   left_box               Draw left arrow box.
2337 B1F1              ;
2338 B1F1 A2 0C 00              ldx   #LEFT_ARROW              Left arrow pattern index.
2339 B1F4 82 C4 00              brl   draw_arrow2
2340 B1F7              ;
2341 B1F7              ;
2342 B1F7              ;= = = = = = = = = = = = = = = = = = =
2343 B1F7              ;          Draw right arrow.
2344 B1F7              ;= = = = = = = = = = = = = = = = = = =
2345 B1F7              ;
2346 B1F7 20 92 B2     draw_right2 jsr   right_box             Draw right arrow box.
2347 B1FA              ;
2348 B1FA A2 0E 00              ldx   #RITE_ARROW              Right arrow pattern index.
2349 B1FD 82 BB 00              brl   draw_arrow2
2350 B200              ;
2351 B200              ;
2352 B200              ;= = = = = = = = = = = = = = = = = =
2353 B200              ;          Draw page region.
2354 B200              ;= = = = = = = = = = = = = = = = = =
2355 B200              ;
2356 B200 5A           draw_page phy                           Save color to use.
2357 B201              ;
2358 B201 A7 11                 lda   [<colorptr]              Get outline color.
2359 B203 A8                    tay   
2360 B204 20 5D A2              jsr   set_patt
2361 B207 DA                    phx   
2362 B208 5A                    phy   
2363 B209 A2 04 30 22           _SetPenPat 
2364 B210              ;
2365 B210 A0 36 00              ldy   #PageRegion+x2
2366 B213 20 2F A4              jsr   CMsetrect2               Set 'rect' to page region.
2367 B216 7A                    ply   
2368 B217              ;
2369 B217 20 72 A1              jsr   pushrect                 For FillRect call.
2370 B21A 5A                    phy                            Pass color.
2371 B21B              ;
2372 B21B 20 72 A1              jsr   pushrect                 Pass address of RECT to frame.
2373 B21E A2 04 53 22           _FrameRect 
2374 B225              ;
2375 B225              ;
2376 B225 20 72 A1              jsr   pushrect
2377 B228 20 64 A1              jsr   pushVvert_pen
2378 B22B F4 01 00              pea   1
2379 B22E A2 04 4C 22           _InsetRect 
2380 B235              ;
2381 B235 7A                    ply                            Color index to use.
2382 B236 B7 11                 lda   [<colorptr],y
2383 B238 A8                    tay   
2384 B239 20 5D A2              jsr   set_patt
2385 B23C DA                    phx   
2386 B23D 5A                    phy   
2387 B23E A2 04 57 22           _FillRect 
2388 B245              ;
2389 B245 82 9A EF              brl   dereference
2390 B248              ;
2391 B248              ;
2392 B248              ;= = = = = = = = = = = = = = = = = = = = = = = = =
2393 B248              ;          Draw scroll bar thumb.
2394 B248              ;= = = = = = = = = = = = = = = = = = = = = = = = =
2395 B248              ;
2396 B248                       EXPORT draw_thumb 
2397 B248              draw_thumb                              ;
2398 B248              ;
2399 B248 A0 2E 00              ldy   #Thumb+x2
2400 B24B 20 2F A4              jsr   CMsetrect2               Put thumber coordinates into 'rect'.
2401 B24E              ;
2402 B24E A0 08 00              ldy   #ThumbNorColor           Index to color of thumb.
2403 B251 B7 11                 lda   [<colorPtr],y
2404 B253 29 F0 00              and   #$00F0
2405 B256 A8                    tay                            Pass interior color.
2406 B257 A7 11                 lda   [<colorPtr]              Pass frame color.
2407 B259 29 F0 00              and   #$00F0
2408 B25C 20 16 A3              jsr   drawrect
2409 B25F              ;
2410 B25F 82 80 EF              brl   dereference
2411 B262
2412 B262                       ENDP 
2413 B262
2414 B262
2415 B262              ;====================================================================
2416 B262              ;
2417 B262              ;          Draw a up arrow box.
2418 B262              ;
2419 B262              ;====================================================================
2420 B262              up_box   proc EXPORT 
2421 B262
2422 B262 20 2C A4              jsr   CMsetrect                Put enclosing RECT into 'rect'.
2423 B265              ;
2424 B265 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
2425 B268 A0 30 00              ldy   #PageRegion+y1
2426 B26B B7 05                 lda   [<Ctlptr],y
2427 B26D 1A                    inc   a
2428 B26E 85 19                 sta   <rect+y2
2429 B270 80 2E                 bra   common
2430 B272              ;
2431 B272              ; = = = = = = = = = = = = = = = = = = = =
2432 B272              ;          Draw a down arrow box.
2433 B272              ; = = = = = = = = = = = = = = = = = = = =
2434 B272              ;
2435 B272                       EXPORT down_box 
2436 B272              down_box                                ;
2437 B272              ;
2438 B272 20 2C A4              jsr   CMsetrect                Put enclosing RECT into 'rect'.
2439 B275              ;
2440 B275 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
2441 B278 A0 34 00              ldy   #PageRegion+y2
2442 B27B B7 05                 lda   [<Ctlptr],y
2443 B27D 3A                    dec   a
2444 B27E 85 15                 sta   <rect+y1
2445 B280 80 1E                 bra   common
2446 B282              ;
2447 B282              ;
2448 B282              ; = = = = = = = = = = = = = = = = = = = =
2449 B282              ;          Draw a left arrow box.
2450 B282              ; = = = = = = = = = = = = = = = = = = = =
2451 B282              ;
2452 B282                       EXPORT left_box 
2453 B282              left_box                                ;
2454 B282              ;
2455 B282 20 2C A4              jsr   CMsetrect                Put enclosing RECT into 'rect'.
2456 B285              ;
2457 B285 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
2458 B288 A0 32 00              ldy   #PageRegion+x1
2459 B28B B7 05                 lda   [<Ctlptr],y
2460 B28D 1A                    inc   a
2461 B28E 85 1B                 sta   <rect+x2
2462 B290 80 0E                 bra   common
2463 B292              ;
2464 B292              ;
2465 B292              ; = = = = = = = = = = = = = = = = = = = =
2466 B292              ;          Draw a right arrow box.
2467 B292              ; = = = = = = = = = = = = = = = = = = = =
2468 B292              ;
2469 B292                       EXPORT right_box 
2470 B292              right_box                               ;
2471 B292              ;
2472 B292 20 2C A4              jsr   CMsetrect                Put enclosing RECT into 'rect'.
2473 B295              ;
2474 B295 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
2475 B298 A0 36 00              ldy   #PageRegion+x2
2476 B29B B7 05                 lda   [<Ctlptr],y
2477 B29D 3A                    dec   a
2478 B29E 85 17                 sta   <rect+x1
2479 B2A0              ;
2480 B2A0 A9 02 00     common   lda   #simpNorBack             Arrow box's interior color index.
2481 B2A3 18                    clc   
2482 B2A4 A0 50 00              ldy   #state
2483 B2A7 77 41                 adc   [<data],y
2484 B2A9 A8                    tay   
2485 B2AA B7 11                 lda   [<colorPtr],y
2486 B2AC 29 F0 00              and   #$00F0
2487 B2AF A8                    tay                            Pass interior color.
2488 B2B0 A7 11                 lda   [<colorPtr]              Pass frame color.
2489 B2B2 29 F0 00              and   #$00F0
2490 B2B5 20 16 A3              jsr   drawrect                 Draw box.
2491 B2B8              ;
2492 B2B8 82 27 EF              brl   dereference
2493 B2BB
2494 B2BB                       ENDP 
2495 B2BB
2496 B2BB
2497 B2BB                       title 'SCROLL_PROC -- utilities' 
2498 B2BB              ;====================================================================
2499 B2BB              ;
2500 B2BB              ;          Draw a scroll bar arrow.
2501 B2BB              ;
2502 B2BB              ;   IN:    state = 0 to draw normal, 2 to draw as selected.
2503 B2BB              ;          colorptr = pointer to color table.
2504 B2BB              ;          rect = enclosing RECT.
2505 B2BB              ;          x = icon number.
2506 B2BB              ;
2507 B2BB              ;  OUT:    rect = arrow's enclosing RECT.
2508 B2BB              ;
2509 B2BB              ;====================================================================
2510 B2BB              draw_arrow2 proc EXPORT 
2511 B2BB
2512 B2BB DA                    phx   
2513 B2BC              ;
2514 B2BC BF 35 A4 FD           lda   >arrowMap-UP_ARROW,x
2515 B2C0 A8                    tay   
2516 B2C1 B7 41                 lda   [<data],y                Get height of arrow.
2517 B2C3 BB                    tyx   
2518 B2C4 A0 21 00              ldy   #rect2+y2
2519 B2C7 97 41                 sta   [<data],y
2520 B2C9 9B                    txy   
2521 B2CA C8                    iny   
2522 B2CB C8                    iny   
2523 B2CC B7 41                 lda   [<data],y                Get width of arrow.
2524 B2CE A0 23 00              ldy   #rect2+x2
2525 B2D1 97 41                 sta   [<data],y
2526 B2D3              ;
2527 B2D3 FA                    plx   
2528 B2D4 20 E0 B2              jsr   center_hor               Center the arrow horizontally.
2529 B2D7 90 06                 bcc   exit                     Did the arrow fit in the box?
2530 B2D9              ;
2531 B2D9              ;                                       x = icon to print.
2532 B2D9 20 BB AC              jsr   print_icon               Print arrow icon.
2533 B2DC              ;
2534 B2DC 82 03 EF              brl   dereference
2535 B2DF              ;
2536 B2DF 60           exit     rts   
2537 B2E0
2538 B2E0                       ENDP 
2539 B2E0
2540 B2E0
2541 B2E0              ;====================================================================
2542 B2E0              ;
2543 B2E0              ;          Center an icon horizontally.
2544 B2E0              ;
2545 B2E0              ;   IN:    rect2+x2 = icon's width.
2546 B2E0              ;          rect = RECT to center in.
2547 B2E0              ;
2548 B2E0              ;  OUT:    Carry flag is clear if icon won't fit inside of 'rect'.
2549 B2E0              ;          rect+x1 = starting position of icon to be horizontally center.
2550 B2E0              ;          x = unchanged.
2551 B2E0              ;
2552 B2E0              ;====================================================================
2553 B2E0              center_hor proc EXPORT 
2554 B2E0
2555 B2E0 A5 1B                 lda   <rect+x2                 Get width of box.
2556 B2E2 38                    sec   
2557 B2E3 E5 17                 sbc   <rect+x1
2558 B2E5 38                    sec   
2559 B2E6 A0 23 00              ldy   #rect2+x2                Less width of arrow.
2560 B2E9 F7 41                 sbc   [<data],y
2561 B2EB 90 07                 bcc   exit                     Arrow won't fix in arrow box.
2562 B2ED 4A                    lsr   a                        Half way.
2563 B2EE 18                    clc   
2564 B2EF 65 17                 adc   <rect+x1
2565 B2F1 85 17                 sta   <rect+x1                 X point to draw arrow.
2566 B2F3              ;
2567 B2F3 38                    sec                            Set OK flag.
2568 B2F4 60           exit     rts   
2569 B2F5
2570 B2F5                       ENDP 
2571 B2F5
2572 B2F5
2573 B2F5              ;====================================================================
2574 B2F5              ;
2575 B2F5              ;        Set new Minimum and Maximum for scroll bar.
2576 B2F5              ;
2577 B2F5              ;   IN:    Ctlptr = pointer to scroll bar.
2578 B2F5              ;          param = new view, $FFFF to not set.
2579 B2F5              ;          param+2 = new data size, $FFFF to not set.
2580 B2F5              ;
2581 B2F5              ; Change History
2582 B2F5              ;
2583 B2F5              ; 24 Jul 88         Steven Glass
2584 B2F5              ;
2585 B2F5              ; If the view was not changed but the maximum value was changed,
2586 B2F5              ; the code was not going through the validation that it goes through
2587 B2F5              ; when the view is changed.  This allowed the max to be less than
2588 B2F5              ; the view.
2589 B2F5              ;
2590 B2F5              ; Added new label @skip2 which is now branched to when view is not
2591 B2F5              ; changed.  old code branched straight to redraw.
2592 B2F5              ;
2593 B2F5              ; Note that this code already tried to maintain a valid value, but
2594 B2F5              ; could fail to do so under certain circumstances.
2595 B2F5              ;
2596 B2F5              ;====================================================================
2597 B2F5              newView  proc EXPORT 
2598 B2F5
2599 B2F5              offset   equ   work                     Zero page usage.
2600 B2F5              height   equ   offset+2                 Height of page region.
2601 B2F5              front    equ   height+2
2602 B2F5              thumb_h  equ   front+2                  Height of thumber.
2603 B2F5              trect    equ   thumb_h+2
2604 B2F5
2605 B2F5
2606 B2F5 20 B6 B5              jsr    scrollState
2607 B2F8 08                    php   
2608 B2F9
2609 B2F9 20 E2 A1              jsr    dereference             ;ctlPtr = (ctlHand).
2610 B2FC
2611 B2FC A0 1E 00              ldy    #CtlData+2              ;set the parameters to the new view and
2612 B2FF A5 2B                 lda    <param+2                ;..data size for the scroll bar. The
2613 B301 C9 FF FF              cmp    #$FFFF                  ;..reason they weren't already is that
2614 B304 D0 02                 bne    @useParam2              ;..one of them could be $FFFF (no change)
2615 B306 B7 05                 lda    [<ctlPtr],y
2616 B308 85 2B        @useParam2 sta    <param+2
2617 B30A 88                    dey   
2618 B30B 88                    dey   
2619 B30C A5 29                 lda    <param
2620 B30E C9 FF FF              cmp    #$FFFF
2621 B311 D0 02                 bne    @useParam
2622 B313 B7 05                 lda    [<ctlPtr],y
2623 B315 85 29        @useParam sta    <param
2624 B317
2625 B317 A5 2B                 lda    <param+2
2626 B319 38                    sec   
2627 B31A E5 29                 sbc    <param
2628 B31C B0 03                 bcs    @1
2629 B31E A9 00 00              lda    #0
2630 B321 A0 12 00     @1       ldy    #CtlValue               ;is the new maximum less than the current
2631 B324 D7 05                 cmp    [<ctlPtr],y             ;..value ? If not, then reset the value
2632 B326 B0 04                 bcs    @valueOK                ;..to the maximum value.
2633 B328 97 05                 sta    [<ctlPtr],y
2634 B32A 80 13                 bra    @setAndDraw
2635 B32C              @valueOK  
2636 B32C A0 1E 00              ldy    #CtlData+2
2637 B32F A5 2B                 lda    <param+2
2638 B331 D7 05                 cmp    [<ctlPtr],y
2639 B333 D0 0A                 bne    @setAndDraw
2640 B335 88                    dey   
2641 B336 88                    dey   
2642 B337 A5 29                 lda    <param
2643 B339 D7 05                 cmp    [<ctlPtr],y
2644 B33B D0 02                 bne    @setAndDraw
2645 B33D
2646 B33D 28                    plp                            ;nothing changed, so just exit
2647 B33E 60                    rts   
2648 B33F
2649 B33F A0 1E 00     @setAndDraw ldy    #CtlData+2
2650 B342 A5 2B                 lda    <param+2
2651 B344 97 05                 sta    [<ctlPtr],y
2652 B346 88                    dey   
2653 B347 88                    dey   
2654 B348 A5 29                 lda    <param
2655 B34A 97 05                 sta    [<ctlPtr],y
2656 B34C
2657 B34C 20 E1 B3              jsr    new_thumb
2658 B34F
2659 B34F 20 B6 B5              jsr   scrollState              Is scroll bar drawable?
2660 B352 90 05                 bcc   ok2
2661 B354 28                    plp   
2662 B355 90 01                 bcc   noexit
2663 B357 60                    rts   
2664 B358 08           noexit   php   
2665 B359 28           ok2      plp   
2666 B35A 20 E8 B5              jsr   SetupColor
2667 B35D 82 3D FE              brl   inner_scroll             Draw interior of scroll bar.
2668 B360              ;
2669 B360              ;
2670 B360              ;
2671 B360              ;====================================================================
2672 B360              ;
2673 B360              ;        Set new value for thumb
2674 B360              ;
2675 B360              ;   IN:    param has new value of thumb
2676 B360              ;          param+2 has old value of thumb
2677 B360              ;
2678 B360              ; Change History
2679 B360              ;
2680 B360              ; 24 Jul 88         Steven Glass
2681 B360              ;
2682 B360              ; When the thumb value is changed we validate the existing 
2683 B360              ; Max value.  If the thumb has a value that is greater than the
2684 B360              ; MaxValue - ViewSize then something is wrong so we adjust MaxValue.
2685 B360              ;
2686 B360              ; The new MaxValue is set to NewThumbValue+ViewSize.
2687 B360              ;
2688 B360              ; This prevents the thumb from drawing outside the scroll bar or on
2689 B360              ; the arrows.
2690 B360              ;
2691 B360              ;====================================================================
2692 B360
2693 B360                       EXPORT move_thumb 
2694 B360              move_thumb  
2695 B360              ;
2696 B360              ;--- Validate the new value -----------------------------------------
2697 B360              ;
2698 B360 A0 1E 00              ldy   #Ctldata+2               ; compute maximum allowable value
2699 B363 B7 05                 lda   [<CtlPtr],y              ; as Max-View
2700 B365 88                    dey   
2701 B366 88                    dey   
2702 B367 38                    sec   
2703 B368 F7 05                 sbc   [<CtlPtr],y
2704 B36A C5 29                 cmp   param                    ; look at new value
2705 B36C B0 09                 bcs   @MaxOK
2706 B36E B7 05                 lda   [<CtlPtr],y              ; compute new max as Value+View.
2707 B370 18                    clc   
2708 B371 65 29                 adc   param
2709 B373 C8                    iny   
2710 B374 C8                    iny   
2711 B375 97 05                 sta   [<CtlPtr],y
2712 B377              @MaxOK    
2713 B377
2714 B377
2715 B377              ;
2716 B377 20 E1 B3              jsr   new_thumb                Compute new thumber.
2717 B37A              ;
2718 B37A 20 B6 B5              jsr   scrollState              Is scroll bar drawable?
2719 B37D B0 61                 bcs   exit1
2720 B37F              ;
2721 B37F              ;
2722 B37F              ; ------- Compute area of old thumber needing to be erased ---------
2723 B37F              ;
2724 B37F A0 2E 00              ldy   #Thumb+x2
2725 B382 20 2F A4              jsr   CMsetrect2               Get rect of new thumber position.
2726 B385              ;
2727 B385 20 E8 B5              jsr   SetUpColor
2728 B388
2729 B388 A6 2D                 ldx   <offset
2730 B38A B5 15                 lda   <rect+y1,x
2731 B38C D5 35                 cmp   <trect+y1,x
2732 B38E F0 2A                 beq   noerase
2733 B390 90 08                 bcc   skip2
2734 B392 D5 39                 cmp   <trect+y2,x
2735 B394 B0 0C                 bcs   erase
2736 B396 95 39                 sta   <trect+y2,x
2737 B398 80 08                 bra   erase
2738 B39A              ;
2739 B39A B5 19        skip2    lda   <rect+y2,x
2740 B39C D5 35                 cmp   <trect+y1,x
2741 B39E 90 02                 bcc   erase
2742 B3A0 95 35                 sta   <trect+y1,x
2743 B3A2              ;
2744 B3A2              ;
2745 B3A2              erase                                   ; 
2746 B3A2              ;
2747 B3A2 A9 35 00              lda   #trect                   Pass address of rect to FillRect.
2748 B3A5 20 75 A1              jsr   pushzpage
2749 B3A8              ;
2750 B3A8 A0 0C 00              ldy   #PageRgnColor            Page region pattern and color.
2751 B3AB B7 11                 lda   [<colorptr],y
2752 B3AD A8                    tay   
2753 B3AE 20 5D A2              jsr   set_patt
2754 B3B1 DA                    phx                            Pass address of pattern.
2755 B3B2 5A                    phy   
2756 B3B3 A2 04 57 22           _FillRect                      Erase thumber.
2757 B3BA              ;
2758 B3BA              noerase                                 ; 
2759 B3BA              ;
2760 B3BA              ;
2761 B3BA              ; ------- Draw new thumber -------------------------------------
2762 B3BA              ;
2763 B3BA 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
2764 B3BD A2 00 00              ldx   #0                       Normal falg.
2765 B3C0 A0 11 00              ldy   #CtlHilite               Is thumb highlighted?
2766 B3C3 B7 05                 lda   [<Ctlptr],y
2767 B3C5 29 FF 00              and   #$00FF
2768 B3C8 C9 81 00              cmp   #THUMB_PART
2769 B3CB D0 02                 bne   store
2770 B3CD E8                    inx                            Selected.
2771 B3CE E8                    inx   
2772 B3CF A0 50 00     store    ldy   #state
2773 B3D2 8A                    txa   
2774 B3D3 97 41                 sta   [<data],y
2775 B3D5 A0 4E 00              ldy   #active                  Must be active.
2776 B3D8 A9 00 00              lda   #0
2777 B3DB 97 41                 sta   [<data],y
2778 B3DD              ;
2779 B3DD 20 48 B2              jsr   draw_thumb               Draw thumber in new position.
2780 B3E0
2781 B3E0 60           exit1    rts   
2782 B3E1
2783 B3E1
2784 B3E1              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
2785 B3E1              ;        Given a new value, compute new thumber for scroll bar.
2786 B3E1              ;
2787 B3E1              ;   IN:  Ctlptr = pointer to scroll bar.
2788 B3E1              ;
2789 B3E1              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
2790 B3E1                       EXPORT new_thumb 
2791 B3E1              new_thumb                               ;
2792 B3E1              ;
2793 B3E1              ;
2794 B3E1 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
2795 B3E4 A2 00 00              ldx   #0                       Offset for vertical scroll bar.
2796 B3E7 A0 10 00              ldy   #CtlFlag
2797 B3EA B7 05                 lda   [<Ctlptr],y
2798 B3EC 29 10 00              and   #DIR_SCROLL
2799 B3EF F0 02                 beq   store1
2800 B3F1 E8                    inx   
2801 B3F2 E8                    inx                            Offset for horizontal scroll bar.
2802 B3F3 86 2D        store1   stx   <offset
2803 B3F5              ;
2804 B3F5              ;
2805 B3F5              ; --- Remember the old thumber ---------------------------
2806 B3F5              ;
2807 B3F5 A0 36 00              ldy   #PageRegion+x2
2808 B3F8 20 2F A4              jsr   CMsetrect2               rect = page region.
2809 B3FB              ;
2810 B3FB 20 72 A1              jsr   pushrect
2811 B3FE 20 64 A1              jsr   pushVvert_pen
2812 B401 F4 01 00              pea   1
2813 B404 A2 04 4C 22           _InsetRect 
2814 B40B              ;
2815 B40B 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
2816 B40E              ;
2817 B40E A6 2D                 ldx   <offset
2818 B410 B5 15                 lda   <rect,x
2819 B412 85 31                 sta   <front                   Front side of page region.
2820 B414              ;
2821 B414 B5 19                 lda   <rect+y2,x               Compute height of page region.
2822 B416 38                    sec   
2823 B417 F5 15                 sbc   <rect,x
2824 B419 85 2F                 sta   <height
2825 B41B              ;
2826 B41B              ;
2827 B41B              ; --- Compute new RECT for thumber ----------------------------------
2828 B41B              ;
2829 B41B A0 2E 00              ldy   #Thumb+x2
2830 B41E 20 2F A4              jsr   CMsetrect2               rect = thumber.
2831 B421              ;
2832 B421 A2 06 00              ldx   #x2                      Save current thumber rect.
2833 B424 B5 15        lop2     lda   <rect,x
2834 B426 95 35                 sta   <trect,x
2835 B428 CA                    dex   
2836 B429 CA                    dex   
2837 B42A 10 F8                 bpl   lop2
2838 B42C              ;
2839 B42C              ;
2840 B42C              ; ------- Get size of thumber ----------------------------------------
2841 B42C              ;
2842 B42C A0 1C 00              ldy   #CtlData                 op1 = view size.
2843 B42F B7 05                 lda   [<Ctlptr],y
2844 B431 AA                    tax                            op1 = view size.
2845 B432 C8                    iny   
2846 B433 C8                    iny   
2847 B434 B7 05                 lda   [<Ctlptr],y              op3 = total size of data area.
2848 B436 A4 2F                 ldy   <height                  op2 = size of page region.
2849 B438 20 CF A0              jsr   fraction
2850 B43B              ;
2851 B43B              ;
2852 B43B              ; ------ Check minimum thumb size --------------------------------
2853 B43B              ;
2854 B43B 8A                    txa   
2855 B43C A6 2D                 ldx   <offset                  Horizontal or Vertical scroll bar?
2856 B43E F0 09                 beq   ck_vermin
2857 B440              ;
2858 B440 A0 4C 00              ldy   #min_thumb
2859 B443 D7 41                 cmp   [<data],y                Minimum thumber size.
2860 B445 B0 0A                 bcs   store3
2861 B447 B7 41                 lda   [<data],y                (Let it fall through, always 8 or more.)
2862 B449              ;
2863 B449 C9 08 00     ck_vermin cmp   #8
2864 B44C B0 03                 bcs   store3
2865 B44E A9 08 00              lda   #8
2866 B451              ;
2867 B451 85 33        store3   sta   <thumb_h                 Number of pixels in thumber.
2868 B453              ;
2869 B453              ;
2870 B453              ;
2871 B453 A5 2F                 lda   <height                  Shrink page region by thumber size.
2872 B455 38                    sec   
2873 B456 E5 33                 sbc   <thumb_h
2874 B458 85 2F                 sta   <height
2875 B45A              ;
2876 B45A              ;
2877 B45A              ; ------- Get starting position of thumber first --------------------
2878 B45A              ;
2879 B45A 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
2880 B45D A0 12 00              ldy   #CtlValue
2881 B460 B7 05                 lda   [<Ctlptr],y
2882 B462 AA                    tax                            op1 = current value.
2883 B463 A0 1E 00              ldy   #CtlData+2
2884 B466 B7 05                 lda   [<Ctlptr],y
2885 B468 88                    dey   
2886 B469 88                    dey   
2887 B46A 38                    sec   
2888 B46B F7 05                 sbc   [<Ctlptr],y              op3 = data size - view size.
2889 B46D A4 2F                 ldy   <height                  op2 = page height - thumb height.
2890 B46F 20 CF A0              jsr   fraction
2891 B472 DA                    phx                            Number of pixels in front of thumber.
2892 B473              ;
2893 B473              ;
2894 B473              ; ------- Update thumber rect ----------------------------------------
2895 B473              ;
2896 B473 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
2897 B476 A9 28 00              lda   #Thumb
2898 B479 18                    clc   
2899 B47A 65 2D                 adc   <offset
2900 B47C A8                    tay   
2901 B47D              ;
2902 B47D 68                    pla                            Number of pixels in front of thumber.
2903 B47E 18                    clc   
2904 B47F 65 31                 adc   <front
2905 B481 97 05                 sta   [<Ctlptr],y
2906 B483 C8                    iny   
2907 B484 C8                    iny   
2908 B485 C8                    iny   
2909 B486 C8                    iny   
2910 B487 18                    clc   
2911 B488 65 33                 adc   <thumb_h
2912 B48A 97 05                 sta   [<Ctlptr],y
2913 B48C              ;
2914 B48C 60                    rts   
2915 B48D
2916 B48D                       ENDP 
2917 B48D
2918 B48D
2919 B48D              ;====================================================================
2920 B48D              ;
2921 B48D              ;          Move scroll bar.
2922 B48D              ;
2923 B48D              ;   IN:    param = delta y.
2924 B48D              ;          param+2 = delta x.
2925 B48D              ;
2926 B48D              ;  OUT:    offset page and thumb RECTs.
2927 B48D              ;
2928 B48D              ;====================================================================
2929 B48D              move_bar proc EXPORT 
2930 B48D
2931 B48D A9 28 00              lda   #Thumb                   Offset thumber.
2932 B490 20 96 B4              jsr   offsetRect
2933 B493              ;
2934 B493 A9 30 00              lda   #PageRegion              Offset page region.
2935 B496              ;
2936 B496 20 35 99     offsetRect jsr   pushrecord
2937 B499 D4 2B                 pei   <param+2                 Pass delta x.
2938 B49B D4 29                 pei   <param                   Pass delta y.
2939 B49D A2 04 4B 22           _OffsetRect                    Move the enclosing RECT.
2940 B4A4              ;
2941 B4A4 60                    rts   
2942 B4A5
2943 B4A5                       ENDP 
2944 B4A5
2945 B4A5
2946 B4A5              ;====================================================================
2947 B4A5              ;
2948 B4A5              ;                Setup to drag indicator.
2949 B4A5              ;
2950 B4A5              ;   IN:    Ctlptr = pointer to control.
2951 B4A5              ;          colorptr = pointer to control's color table.
2952 B4A5              ;
2953 B4A5              ;  OUT:    limit_blk initialized.
2954 B4A5              ;
2955 B4A5              ;====================================================================
2956 B4A5              setup_drag proc EXPORT 
2957 B4A5
2958 B4A5              ;
2959 B4A5              ; --------- Perform default setup ----------------------------------
2960 B4A5              ;
2961 B4A5 20 E8 B5              jsr   setupcolor               Get control's color table pointer.
2962 B4A8              ;
2963 B4A8 A0 0C 00              ldy   #PageRgnColor            Page region's color and pattern.
2964 B4AB B7 11                 lda   [<colorptr],y
2965 B4AD A8                    tay   
2966 B4AE 20 5D A2              jsr   set_patt
2967 B4B1 98                    tya   
2968 B4B2 A0 78 00              ldy   #drag_patt
2969 B4B5 97 41                 sta   [<data],y
2970 B4B7 C8                    iny   
2971 B4B8 C8                    iny   
2972 B4B9 8A                    txa   
2973 B4BA 97 41                 sta   [<data],y
2974 B4BC              ;
2975 B4BC              ;
2976 B4BC              ; ---------- Clone page region for bounds and slop RECTs -----------
2977 B4BC              ;
2978 B4BC 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
2979 B4BF A0 36 00              ldy   #PageRegion+x2           Get page region.
2980 B4C2 A2 74 00              ldx   #slop_rect+x2
2981 B4C5 B7 05        lop3     lda   [<Ctlptr],y
2982 B4C7 5A                    phy   
2983 B4C8 9B                    txy   
2984 B4C9 97 41                 sta   [<data],y
2985 B4CB 7A                    ply   
2986 B4CC CA                    dex   
2987 B4CD CA                    dex   
2988 B4CE 88                    dey   
2989 B4CF 88                    dey   
2990 B4D0 C0 30 00              cpy   #PageRegion
2991 B4D3 B0 F0                 bcs   lop3
2992 B4D5              ;
2993 B4D5 A0 36 00              ldy   #PageRegion+x2           Get page region.
2994 B4D8 A2 6C 00              ldx   #bound_rect+x2
2995 B4DB B7 05        lop4     lda   [<Ctlptr],y
2996 B4DD 5A                    phy   
2997 B4DE 9B                    txy   
2998 B4DF 97 41                 sta   [<data],y
2999 B4E1 7A                    ply   
3000 B4E2 CA                    dex   
3001 B4E3 CA                    dex   
3002 B4E4 88                    dey   
3003 B4E5 88                    dey   
3004 B4E6 C0 30 00              cpy   #PageRegion
3005 B4E9 B0 F0                 bcs   lop4
3006 B4EB              ;
3007 B4EB              ;
3008 B4EB              ; ---------- Compute bounds RECT from page region ------------------
3009 B4EB              ;
3010 B4EB 20 44 A1              jsr   pushbound_rect
3011 B4EE 20 64 A1              jsr   pushVvert_pen
3012 B4F1 F4 01 00              pea   1
3013 B4F4 A2 04 4C 22           _InsetRect 
3014 B4FB              ;
3015 B4FB              ;
3016 B4FB              ; ---------- Compute slop RECT from page region --------------------
3017 B4FB              ;
3018 B4FB 20 49 A1              jsr   pushslop_rect
3019 B4FE              ;
3020 B4FE 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
3021 B501 A0 10 00              ldy   #CtlFlag                 Check directon.
3022 B504 B7 05                 lda   [<Ctlptr],y
3023 B506              ;
3024 B506 A0 CE FF              ldy   #$FFCE                   50 pixels vertical slop.
3025 B509 A2 E7 FF              ldx   #$FFE7                   25 pixels horizontal slop.
3026 B50C 29 10 00              and   #DIR_SCROLL              Vertical or horizontal?
3027 B50F F0 06                 beq   store2                   Equal if vertical scroll bar.
3028 B511              ;
3029 B511 A0 F0 FF              ldy   #$FFF0                   16 pixels vertical slop.
3030 B514 A2 B0 FF              ldx   #$FFB0                   80 pixels horizontal slop.
3031 B517              ;
3032 B517 DA           store2   phx                            Pass horizontal slop to _InsetRect.
3033 B518 5A                    phy                            Pass vertical slop to _InsetRect.
3034 B519              ;
3035 B519 A0 4A 00              ldy   #GraphicsMode            320 or 640?
3036 B51C B7 41                 lda   [<data],y
3037 B51E F0 05                 beq   store3                   If 320, I'm ready.
3038 B520              ;
3039 B520 A3 03                 lda   3,s
3040 B522 0A                    asl   a                        Double horizontal slop in 640.
3041 B523 83 03                 sta   3,s
3042 B525              ;
3043 B525 A2 04 4C 22  store3   _InsetRect 
3044 B52C              ;
3045 B52C              ;
3046 B52C              ; ---------- Set default movement axis -----------------------------
3047 B52C              ;
3048 B52C 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
3049 B52F A2 02 00              ldx   #2                       Allow vertical flag.
3050 B532 A0 10 00              ldy   #CtlFlag                 Check direction.
3051 B535 B7 05                 lda   [<Ctlptr],y
3052 B537 29 10 00              and   #DIR_SCROLL
3053 B53A F0 01                 beq   store1
3054 B53C CA                    dex                            Allow horizontal flag.
3055 B53D 8A           store1   txa   
3056 B53E A0 76 00              ldy   #axis_param
3057 B541 97 41                 sta   [<data],y
3058 B543
3059 B543 60                    rts   
3060 B544
3061 B544                       ENDP 
3062 B544
3063 B544
3064 B544              ;====================================================================
3065 B544              ;
3066 B544              ;          Perform default reposition of indicator.
3067 B544              ;
3068 B544              ;   IN:    Ctlhand = handle of control.
3069 B544              ;          param = delta y.
3070 B544              ;          param+2 = delta x.
3071 B544              ;
3072 B544              ;  OUT:    offset page and thumb RECTs.
3073 B544              ;
3074 B544              ;====================================================================
3075 B544              reposition proc EXPORT 
3076 B544
3077 B544 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
3078 B547              ;
3079 B547 A0 2E 00              ldy   #Thumb+x2
3080 B54A 20 2F A4              jsr   CMsetrect2               rect = indicator.
3081 B54D              ;
3082 B54D A0 10 00              ldy   #CtlFlag                 Is it a vertical scroll bar?
3083 B550 B7 05                 lda   [<Ctlptr],y
3084 B552 A4 29                 ldy   <param                   Y delta.
3085 B554 A6 2B                 ldx   <param+2                 X delta.
3086 B556              ;
3087 B556 29 10 00              and   #DIR_SCROLL              Is it a vertical scroll bar?
3088 B559 F0 06                 beq   ckvert
3089 B55B              ;
3090 B55B 9B                    txy                            Horizontal, change top and bottom.
3091 B55C A2 02 00              ldx   #x1
3092 B55F 80 03                 bra   enter2
3093 B561              ;
3094 B561 A2 00 00     ckvert   ldx   #y1
3095 B564              ;
3096 B564 98           enter2   tya                            Amount of change.
3097 B565 18                    clc   
3098 B566 75 15                 adc   <rect,x                  New leading edge of thumber.
3099 B568 A8                    tay                            Save thumber leading edge.
3100 B569              ;
3101 B569 B5 19                 lda   <rect+y2,x
3102 B56B 38                    sec   
3103 B56C F5 15                 sbc   <rect,x
3104 B56E 48                    pha                            Size of thumber.
3105 B56F 5A                    phy                            Save new leading edge.
3106 B570              ;
3107 B570 DA                    phx   
3108 B571 A0 36 00              ldy   #PageRegion+x2
3109 B574 20 2F A4              jsr   CMsetrect2               rect = page region.
3110 B577              ;
3111 B577 20 72 A1              jsr   pushrect                 Less page region's border.
3112 B57A 20 64 A1              jsr   pushVvert_pen
3113 B57D F4 01 00              pea   1
3114 B580 A2 04 4C 22           _InsetRect 
3115 B587 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
3116 B58A              ;
3117 B58A FA                    plx   
3118 B58B              ;
3119 B58B B5 19                 lda   <rect+y2,x
3120 B58D 38                    sec   
3121 B58E F5 15                 sbc   <rect,x                  Page region size,
3122 B590 38                    sec   
3123 B591 E3 03                 sbc   3,s                      less size of thumber.
3124 B593 83 03                 sta   3,s                      op3 = page size - thumb size.
3125 B595              ;
3126 B595 68                    pla                            Get new leading thumb edge,
3127 B596 38                    sec   
3128 B597 F5 15                 sbc   <rect,x                  less page edge,
3129 B599 AA                    tax                            op1 = number of pixels in front of thumb.
3130 B59A              ;
3131 B59A A0 1E 00              ldy   #CtlData+2
3132 B59D B7 05                 lda   [<Ctlptr],y              op2 = data size,
3133 B59F 88                    dey   
3134 B5A0 88                    dey   
3135 B5A1 38                    sec   
3136 B5A2 F7 05                 sbc   [<Ctlptr],y              less view size.
3137 B5A4 A8                    tay   
3138 B5A5 68                    pla                            Get op3.
3139 B5A6 20 CF A0              jsr   fraction                 Compute proportion equation.
3140 B5A9              ;
3141 B5A9              ;
3142 B5A9              ; --- Set scroll bar's new value -------------------
3143 B5A9              ;
3144 B5A9 DA                    phx                            Pass new value.
3145 B5AA D4 03                 pei   <Ctlhand+2               Pass control's handle.
3146 B5AC D4 01                 pei   <Ctlhand
3147 B5AE A2 10 19 22           _SetCtlValue 
3148 B5B5              ;
3149 B5B5 60                    rts   
3150 B5B6
3151 B5B6                       ENDP 
3152 B5B6
3153 B5B6
3154 B5B6              ;====================================================================
3155 B5B6              ;
3156 B5B6              ;          Test to draw control.
3157 B5B6              ;
3158 B5B6              ;  OUT:    Carry set if control is invisible, inactive, or view >= data.
3159 B5B6
3160 B5B6              ;====================================================================
3161 B5B6              scrollState proc EXPORT 
3162 B5B6
3163 B5B6 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
3164 B5B9 A0 1C 00              ldy   #CtlData
3165 B5BC B7 05                 lda   [<Ctlptr],y              Total view.
3166 B5BE C8                    iny   
3167 B5BF C8                    iny   
3168 B5C0 D7 05                 cmp   [<Ctlptr],y              Total data area.
3169 B5C2 B0 13                 bcs   exit                     Everything in view?
3170 B5C4
3171 B5C4 38                    sec                            Don't draw flag.
3172 B5C5              ;
3173 B5C5 A0 10 00              ldy   #CtlFlag
3174 B5C8 B7 05                 lda   [<Ctlptr],y
3175 B5CA 29 80 00              and   #Ctl_INVIS               Is the scroll bar visible?
3176 B5CD D0 08                 bne   exit
3177 B5CF              ;
3178 B5CF A0 4E 00              ldy   #active
3179 B5D2 B7 41                 lda   [<data],y
3180 B5D4 30 01                 bmi   exit
3181 B5D6 18                    clc   
3182 B5D7
3183 B5D7 60           exit     rts   
3184 B5D8
3185 B5D8                       ENDP 
3186 B5D8
3187 B5D8
3188 B5D8              ****************************************************************
3189 B5D8              *
3190 B5D8              CheckForVis PROC 
3191 B5D8              *
3192 B5D8              * This central routine checks the ctlFlag byte to see if
3193 B5D8              * the invisible bit is set.  If it is clear, the routine
3194 B5D8              * returns to the calling routine.
3195 B5D8              *
3196 B5D8              * If the bit is set, this routine pops an extra word off
3197 B5D8              * the stack and returns to the routine that called 
3198 B5D8              * the calling routine.
3199 B5D8              *
3200 B5D8              *
3201 B5D8              * Inputs:
3202 B5D8              *                   <ctlPtr
3203 B5D8              *
3204 B5D8              * Outputs:
3205 B5D8              *                   returns or not
3206 B5D8              *
3207 B5D8              * External Refs:
3208 B5D8              *                   none
3209 B5D8              *
3210 B5D8              * Entry Points:
3211 B5D8              *                   none
3212 B5D8              *
3213 B5D8                       longa on                       ; mode
3214 B5D8                       longi on
3215 B5D8              *
3216 B5D8              ****************************************************************
3217 B5D8
3218 B5D8
3219 B5D8 A0 10 00              ldy   #CtlFlag                 Read the flag
3220 B5DB B7 05                 lda   [<Ctlptr],y
3221 B5DD
3222 B5DD 89 80 00              bit   #ctl_invis               Are we visible?
3223 B5E0 F0 05                 beq   @GoOn                    Yes, go on
3224 B5E2 A9 00 00              lda   #0                       Quit now.
3225 B5E5 AA                    tax   
3226 B5E6 7A                    ply                            Pull off extra RTS and go back to Ctl Mgr
3227 B5E7 60           @GoOn    rts   
3228 B5E8
3229 B5E8                       ENDP 
3230 B5E8
3231 B5E8
3232 B5E8
3233 B5E8
3234 B5E8              ****************************************************************
3235 B5E8              *
3236 B5E8              SetUpColor PROC 
3237 B5E8              *
3238 B5E8              * Sets up colorPtr.
3239 B5E8              *
3240 B5E8              *
3241 B5E8              * In:    CtlHandle
3242 B5E8              *        CtlPtr
3243 B5E8              *
3244 B5E8              * Out:   ColorPtr
3245 B5E8              * 
3246 B5E8              *
3247 B5E8              * External Refs:
3248 B5E8              *                   none
3249 B5E8              *
3250 B5E8              * Entry Points:
3251 B5E8              *                   none
3252 B5E8              *
3253 B5E8                       longa on                       ; mode
3254 B5E8                       longi on
3255 B5E8              *
3256 B5E8              * Change History
3257 B5E8              *
3258 B5E8              * 19 Feb 89         Steven Glass
3259 B5E8              *
3260 B5E8              * This used to be part of ControlMgr.asm.  Now it is part
3261 B5E8              * of DefProcs.  The change was made because the color table
3262 B5E8              * ref was being made and memory manager calls could make
3263 B5E8              * it move.  It was also being made too often.
3264 B5E8              *
3265 B5E8              ****************************************************************
3266 B5E8
3267 B5E8              ;
3268 B5E8              ;-----------------------------------------------------------
3269 B5E8              ;
3270 B5E8              ; Start by copying the reference from the control record
3271 B5E8              ; to ColorPtr.  Who knows, it may even be right.
3272 B5E8              ;
3273 B5E8 A0 24 00              ldy   #CtlColor                Set pointer to the color table.
3274 B5EB B7 05                 lda   [<Ctlptr],y
3275 B5ED 85 11                 sta   <colorptr
3276 B5EF C8                    iny   
3277 B5F0 C8                    iny   
3278 B5F1 B7 05                 lda   [<Ctlptr],y
3279 B5F3 85 13                 sta   <colorptr+2
3280 B5F5
3281 B5F5
3282 B5F5              ;
3283 B5F5              ; If the control is not a super control, we are done.
3284 B5F5              ;
3285 B5F5 A0 16 00              ldy   #NewCtlRecord.ctlProc+2
3286 B5F8 B7 05                 lda   [ctlPtr],y
3287 B5FA 10 2E                 bpl   @Done
3288 B5FC
3289 B5FC              ;
3290 B5FC              ; It is a super control.  See what the verb is.
3291 B5FC              ;
3292 B5FC 20 32 A2              jsr   ReadMoreFlags
3293 B5FF 29 0C 00              and   #ColorTableVerbMask
3294 B602 F0 26                 beq   @Done                    0 is pointer so all done
3295 B604
3296 B604 C9 04 00              cmp   #ColorTableIsHandle
3297 B607 F0 15                 beq   @IsHandle
3298 B609
3299 B609              @IsResource  
3300 B609 48                    pha   
3301 B60A 48                    pha   
3302 B60B F4 0D 80              PushWord #rCtlColorTable 
3303 B60E D4 13                 pei   ColorPtr+2
3304 B610 D4 11                 pei   ColorPtr
3305 B612 20 9C 9D              jsr   LoadResource
3306 B615 68                    pla   
3307 B616 85 11                 sta   ColorPtr
3308 B618 68                    pla   
3309 B619 85 13                 sta   ColorPtr+2
3310 B61B
3311 B61B              ;
3312 B61B              ; memory may have moved, so reset ctlPtr
3313 B61B              ;
3314 B61B 20 E2 A1              jsr   Dereference
3315 B61E
3316 B61E              @IsHandle  
3317 B61E
3318 B61E A0 02 00              ldy   #2
3319 B621 B7 11                 lda   [ColorPtr],y
3320 B623 AA                    tax   
3321 B624 A7 11                 lda   [ColorPtr]
3322 B626 85 11                 sta   ColorPtr
3323 B628 86 13                 stx   ColorPtr+2
3324 B62A
3325 B62A              @Done     
3326 B62A 60                    rts   
3327 B62B
3328 B62B
3329 B62B                       ENDP 
3330 B62B
3331 B62B
3332 B62B                       END   
